/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.cache;

import java.util.List;
import org.springblade.core.cache.utils.CacheUtil;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.system.entity.DictBiz;
import org.springblade.system.enums.DictBizEnum;
import org.springblade.system.feign.IDictBizClient;

public class DictBizCache {
    private static final String DICT_ID = "dictBiz:id";
    private static final String DICT_VALUE = "dictBiz:value";
    private static final String DICT_LIST = "dictBiz:list";
    private static IDictBizClient dictClient;

    private static IDictBizClient getDictClient() {
        if (dictClient == null) {
            dictClient = (IDictBizClient)SpringUtil.getBean(IDictBizClient.class);
        }
        return dictClient;
    }

    public static DictBiz getById(Long id) {
        String keyPrefix = DICT_ID.concat("-").concat(AuthUtil.getTenantId()).concat(":");
        return (DictBiz)CacheUtil.get((String)"blade:dict", (String)keyPrefix, (Object)id, () -> {
            R<DictBiz> result = DictBizCache.getDictClient().getById(id);
            return (DictBiz)result.getData();
        });
    }

    public static String getValue(String clientId, DictBizEnum code, Integer dictKey) {
        return DictBizCache.getValue(clientId, code.getName(), dictKey);
    }

    public static String getValue(String clientId, String code, Integer dictKey) {
        String keyPrefix = DICT_VALUE.concat("-").concat(AuthUtil.getTenantId()).concat(":").concat(clientId).concat(":");
        return (String)CacheUtil.get((String)"blade:dict", (String)(keyPrefix + code + ":"), (Object)String.valueOf(dictKey), () -> {
            R<String> result = DictBizCache.getDictClient().getValue(clientId, code, String.valueOf(dictKey));
            return (String)result.getData();
        });
    }

    public static String getValue(String clientId, DictBizEnum code, String dictKey) {
        return DictBizCache.getValue(clientId, code.getName(), dictKey);
    }

    public static String getValue(String clientId, String code, String dictKey) {
        String keyPrefix = DICT_VALUE.concat("-").concat(AuthUtil.getTenantId()).concat(":").concat(clientId).concat(":");
        return (String)CacheUtil.get((String)"blade:dict", (String)(keyPrefix + code + ":"), (Object)dictKey, () -> {
            R<String> result = DictBizCache.getDictClient().getValue(clientId, code, dictKey);
            return (String)result.getData();
        });
    }

    public static List<DictBiz> getList(String clientId, String code) {
        String keyPrefix = DICT_VALUE.concat("-").concat(AuthUtil.getTenantId()).concat(":").concat(clientId).concat(":");
        return (List)CacheUtil.get((String)"blade:dict", (String)keyPrefix, (Object)code, () -> {
            R<List<DictBiz>> result = DictBizCache.getDictClient().getList(clientId, code);
            return (List)result.getData();
        });
    }
}

