/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.http.cache;

import java.util.HashSet;
import org.springblade.core.http.cache.BladeHttpCacheProperties;
import org.springblade.core.http.cache.HttpCacheInterceptor;
import org.springblade.core.http.cache.HttpCacheService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={BladeHttpCacheProperties.class})
@ConditionalOnProperty(value={"blade.http.cache.enabled"}, havingValue="true")
public class HttpCacheConfiguration
implements WebMvcConfigurer {
    private static final String DEFAULT_STATIC_PATH_PATTERN = "/**";
    private final WebMvcProperties webMvcProperties;
    private final BladeHttpCacheProperties properties;
    private final CacheManager cacheManager;

    @Bean
    public HttpCacheService httpCacheService() {
        return new HttpCacheService(this.properties, this.cacheManager);
    }

    public void addInterceptors(@NonNull InterceptorRegistry registry) {
        HashSet<String> excludePatterns = new HashSet<String>(this.properties.getExcludePatterns());
        String staticPathPattern = this.webMvcProperties.getStaticPathPattern();
        if (!DEFAULT_STATIC_PATH_PATTERN.equals(staticPathPattern.trim())) {
            excludePatterns.add(staticPathPattern);
        }
        HttpCacheInterceptor httpCacheInterceptor = new HttpCacheInterceptor(this.httpCacheService());
        registry.addInterceptor((HandlerInterceptor)httpCacheInterceptor).addPathPatterns(this.properties.getIncludePatterns().toArray(new String[0])).excludePathPatterns(excludePatterns.toArray(new String[0]));
    }

    public HttpCacheConfiguration(WebMvcProperties webMvcProperties, BladeHttpCacheProperties properties, CacheManager cacheManager) {
        this.webMvcProperties = webMvcProperties;
        this.properties = properties;
        this.cacheManager = cacheManager;
    }
}

