/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.http.cache;

import org.springblade.core.http.cache.BladeHttpCacheProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;

public class HttpCacheService
implements InitializingBean {
    private final BladeHttpCacheProperties properties;
    private final CacheManager cacheManager;
    private Cache cache;

    public HttpCacheService(BladeHttpCacheProperties properties, CacheManager cacheManager) {
        this.properties = properties;
        this.cacheManager = cacheManager;
    }

    public boolean get(String key) {
        Boolean result = (Boolean)this.cache.get((Object)key, Boolean.class);
        return Boolean.TRUE.equals(result);
    }

    public void set(String key) {
        this.cache.put((Object)key, (Object)Boolean.TRUE);
    }

    public void remove(String key) {
        this.cache.evict((Object)key);
    }

    public void clear() {
        this.cache.clear();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cacheManager, (String)"cacheManager must not be null!");
        String cacheName = this.properties.getCacheName();
        this.cache = this.cacheManager.getCache(cacheName);
        Assert.notNull((Object)this.cache, (String)("HttpCacheCache cacheName: " + cacheName + " is not config."));
    }
}

