/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.excel.util;

import cn.idev.excel.FastExcel;
import cn.idev.excel.read.builder.ExcelReaderBuilder;
import cn.idev.excel.read.builder.ExcelReaderSheetBuilder;
import cn.idev.excel.read.listener.ReadListener;
import cn.idev.excel.util.DateUtils;
import cn.idev.excel.write.builder.ExcelWriterBuilder;
import cn.idev.excel.write.handler.WriteHandler;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.springblade.core.excel.listener.DataListener;
import org.springblade.core.excel.listener.ImportListener;
import org.springblade.core.excel.support.ExcelException;
import org.springblade.core.excel.support.ExcelImporter;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    public static <T> List<T> read(MultipartFile excel, Class<T> clazz) {
        DataListener dataListener = new DataListener();
        ExcelReaderBuilder builder = ExcelUtil.getReaderBuilder(excel, dataListener, clazz);
        if (builder == null) {
            return null;
        }
        builder.doReadAll();
        return dataListener.getDataList();
    }

    public static <T> List<T> read(MultipartFile excel, int sheetNo, Class<T> clazz) {
        return ExcelUtil.read(excel, sheetNo, 1, clazz);
    }

    public static <T> List<T> read(MultipartFile excel, int sheetNo, int headRowNumber, Class<T> clazz) {
        DataListener dataListener = new DataListener();
        ExcelReaderBuilder builder = ExcelUtil.getReaderBuilder(excel, dataListener, clazz);
        if (builder == null) {
            return null;
        }
        ((ExcelReaderSheetBuilder)builder.sheet(Integer.valueOf(sheetNo)).headRowNumber(Integer.valueOf(headRowNumber))).doRead();
        return dataListener.getDataList();
    }

    public static <T> void save(MultipartFile excel, ExcelImporter<T> importer, Class<T> clazz) {
        ImportListener<T> importListener = new ImportListener<T>(importer);
        ExcelReaderBuilder builder = ExcelUtil.getReaderBuilder(excel, importListener, clazz);
        if (builder != null) {
            builder.doReadAll();
        }
    }

    public static <T> void export(HttpServletResponse response, List<T> dataList, Class<T> clazz) {
        ExcelUtil.export(response, DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"), "\u5bfc\u51fa\u6570\u636e", dataList, clazz);
    }

    public static <T> void export(HttpServletResponse response, String fileName, String sheetName, List<T> dataList, Class<T> clazz) {
        ExcelUtil.export(response, fileName, sheetName, dataList, null, clazz);
    }

    public static <T> void export(HttpServletResponse response, String fileName, String sheetName, List<T> dataList, WriteHandler writeHandler, Class<T> clazz) {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ExcelWriterBuilder write = FastExcel.write((OutputStream)response.getOutputStream(), clazz);
        if (writeHandler != null) {
            write.registerWriteHandler(writeHandler);
        }
        write.sheet(sheetName).doWrite(dataList);
    }

    public static <T> ExcelReaderBuilder getReaderBuilder(MultipartFile excel, ReadListener<T> readListener, Class<T> clazz) {
        String filename = excel.getOriginalFilename();
        if (!StringUtils.hasText((String)filename)) {
            throw new ExcelException("\u8bf7\u4e0a\u4f20\u6587\u4ef6!");
        }
        if (!StringUtils.endsWithIgnoreCase((String)filename, (String)".xls") && !StringUtils.endsWithIgnoreCase((String)filename, (String)".xlsx")) {
            throw new ExcelException("\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684excel\u6587\u4ef6!");
        }
        try {
            BufferedInputStream inputStream = new BufferedInputStream(excel.getInputStream());
            return FastExcel.read((InputStream)inputStream, clazz, readListener);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

