/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public interface ResponseSpec {
    public int code();

    public String message();

    default public boolean isOk() {
        return false;
    }

    public boolean isRedirect();

    public Headers headers();

    default public ResponseSpec headers(Consumer<Headers> consumer) {
        consumer.accept(this.headers());
        return this;
    }

    public List<Cookie> cookies();

    default public ResponseSpec cookies(Consumer<List<Cookie>> consumer) {
        consumer.accept(this.cookies());
        return this;
    }

    public String asString();

    public byte[] asBytes();

    public InputStream asStream();

    public JsonNode asJsonNode();

    @Nullable
    public <T> T asValue(Class<T> var1);

    @Nullable
    public <T> T asValue(TypeReference<T> var1);

    public <T> List<T> asList(Class<T> var1);

    public <K, V> Map<K, V> asMap(Class<?> var1, Class<?> var2);

    public <V> Map<String, V> asMap(Class<?> var1);

    public <T> T asDomValue(Class<T> var1);

    public <T> List<T> asDomList(Class<T> var1);

    public File toFile(File var1);

    public Path toFile(Path var1);

    @Nullable
    public MediaType contentType();

    public long contentLength();

    public Request rawRequest();

    @Nullable
    default public ResponseSpec rawRequest(Consumer<Request> consumer) {
        consumer.accept(this.rawRequest());
        return this;
    }

    public Response rawResponse();

    default public ResponseSpec rawResponse(Consumer<Response> consumer) {
        consumer.accept(this.rawResponse());
        return this;
    }

    @Nullable
    public ResponseBody rawBody();

    @Nullable
    default public ResponseSpec rawBody(Consumer<ResponseBody> consumer) {
        consumer.accept(this.rawBody());
        return this;
    }
}

