/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.minio.config;

import io.minio.MinioClient;
import org.springblade.core.oss.config.OssConfiguration;
import org.springblade.core.oss.minio.MinioTemplate;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.BladeOssRule;
import org.springblade.core.oss.rule.OssRule;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={OssConfiguration.class})
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="minio")
public class MinioConfiguration {
    private final OssProperties ossProperties;

    @Bean
    @ConditionalOnMissingBean(value={OssRule.class})
    public OssRule ossRule() {
        return new BladeOssRule(this.ossProperties.getTenantMode());
    }

    @Bean
    @ConditionalOnMissingBean(value={MinioClient.class})
    public MinioClient minioClient() {
        return new MinioClient(this.ossProperties.getEndpoint(), this.ossProperties.getAccessKey(), this.ossProperties.getSecretKey());
    }

    @Bean
    @ConditionalOnBean(value={MinioClient.class, OssRule.class})
    @ConditionalOnMissingBean(value={MinioTemplate.class})
    public MinioTemplate minioTemplate(MinioClient minioClient, OssRule ossRule) {
        return new MinioTemplate(minioClient, ossRule, this.ossProperties);
    }

    public MinioConfiguration(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }
}

