/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.tencent;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectResult;
import java.io.InputStream;
import java.util.List;
import org.springblade.core.oss.OssTemplate;
import org.springblade.core.oss.model.BladeFile;
import org.springblade.core.oss.model.OssFile;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class TencentCosTemplate
implements OssTemplate {
    private final COSClient cosClient;
    private final OssProperties ossProperties;
    private final OssRule ossRule;

    public void makeBucket(String bucketName) {
        if (!this.bucketExists(bucketName)) {
            this.cosClient.createBucket(this.getBucketName(bucketName));
            this.cosClient.setBucketAcl(this.getBucketName(bucketName), CannedAccessControlList.PublicRead);
        }
    }

    public void removeBucket(String bucketName) {
        this.cosClient.deleteBucket(this.getBucketName(bucketName));
    }

    public boolean bucketExists(String bucketName) {
        return this.cosClient.doesBucketExist(this.getBucketName(bucketName));
    }

    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.cosClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), fileName);
    }

    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.cosClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), destFileName);
    }

    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    public OssFile statFile(String bucketName, String fileName) {
        ObjectMetadata stat = this.cosClient.getObjectMetadata(this.getBucketName(bucketName), fileName);
        OssFile ossFile = new OssFile();
        ossFile.setName(fileName);
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(stat.getContentMD5());
        ossFile.setLength(stat.getContentLength());
        ossFile.setPutTime(stat.getLastModified());
        ossFile.setContentType(stat.getContentType());
        return ossFile;
    }

    public String filePath(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    public String filePath(String bucketName, String fileName) {
        return this.getOssHost(bucketName).concat("/").concat(fileName);
    }

    public String fileLink(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    public String fileLink(String bucketName, String fileName) {
        return this.getOssHost(bucketName).concat("/").concat(fileName);
    }

    public BladeFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    public BladeFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    public BladeFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, fileName, file.getInputStream());
    }

    public BladeFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    public BladeFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.put(bucketName, stream, fileName, false);
    }

    public BladeFile put(String bucketName, InputStream stream, String key, boolean cover) {
        this.makeBucket(bucketName);
        String originalName = key;
        key = this.getFileName(key);
        if (cover) {
            this.cosClient.putObject(this.getBucketName(bucketName), key, stream, null);
        } else {
            PutObjectResult response = this.cosClient.putObject(this.getBucketName(bucketName), key, stream, null);
            int retryCount = 5;
            for (int retry = 0; StringUtils.isEmpty((Object)response.getETag()) && retry < retryCount; ++retry) {
                response = this.cosClient.putObject(this.getBucketName(bucketName), key, stream, null);
            }
        }
        BladeFile file = new BladeFile();
        file.setOriginalName(originalName);
        file.setName(key);
        file.setDomain(this.getOssHost(bucketName));
        file.setLink(this.fileLink(bucketName, key));
        return file;
    }

    public void removeFile(String fileName) {
        this.cosClient.deleteObject(this.getBucketName(), fileName);
    }

    public void removeFile(String bucketName, String fileName) {
        this.cosClient.deleteObject(this.getBucketName(bucketName), fileName);
    }

    public void removeFiles(List<String> fileNames) {
        fileNames.forEach(this::removeFile);
    }

    public void removeFiles(String bucketName, List<String> fileNames) {
        fileNames.forEach(fileName -> this.removeFile(this.getBucketName(bucketName), (String)fileName));
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName).concat("-").concat(this.ossProperties.getAppId());
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    public String getOssHost(String bucketName) {
        return "http://" + this.cosClient.getClientConfig().getEndpointBuilder().buildGeneralApiEndpoint(this.getBucketName(bucketName));
    }

    public String getOssHost() {
        return this.getOssHost(this.ossProperties.getBucketName());
    }

    public TencentCosTemplate(COSClient cosClient, OssProperties ossProperties, OssRule ossRule) {
        this.cosClient = cosClient;
        this.ossProperties = ossProperties;
        this.ossRule = ossRule;
    }
}

