/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.tencent.config;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.region.Region;
import org.springblade.core.oss.config.OssConfiguration;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.BladeOssRule;
import org.springblade.core.oss.rule.OssRule;
import org.springblade.core.oss.tencent.TencentCosTemplate;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={OssConfiguration.class})
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="tencentcos")
public class TencentCosConfiguration {
    private final OssProperties ossProperties;

    @Bean
    @ConditionalOnMissingBean(value={OssRule.class})
    public OssRule ossRule() {
        return new BladeOssRule(this.ossProperties.getTenantMode());
    }

    @Bean
    @ConditionalOnMissingBean(value={COSClient.class})
    public COSClient ossClient() {
        BasicCOSCredentials credentials = new BasicCOSCredentials(this.ossProperties.getAccessKey(), this.ossProperties.getSecretKey());
        Region region = new Region(this.ossProperties.getRegion());
        ClientConfig clientConfig = new ClientConfig(region);
        clientConfig.setMaxConnectionsCount(1024);
        clientConfig.setSocketTimeout(50000);
        clientConfig.setConnectionTimeout(50000);
        clientConfig.setConnectionRequestTimeout(1000);
        return new COSClient((COSCredentials)credentials, clientConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={TencentCosTemplate.class})
    @ConditionalOnBean(value={COSClient.class, OssRule.class})
    public TencentCosTemplate tencentCosTemplate(COSClient cosClient, OssRule ossRule) {
        return new TencentCosTemplate(cosClient, this.ossProperties, ossRule);
    }

    public TencentCosConfiguration(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }
}

