/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.report.provider;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bstek.ureport.provider.report.ReportFile;
import com.bstek.ureport.provider.report.ReportProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.report.entity.ReportFileEntity;
import org.springblade.report.props.ReportDatabaseProperties;
import org.springblade.report.service.IReportFileService;

public class DatabaseProvider
implements ReportProvider {
    private final ReportDatabaseProperties properties;
    private final IReportFileService service;

    public InputStream loadReport(String file) {
        ReportFileEntity reportFileEntity = (ReportFileEntity)this.service.getOne((Wrapper)Wrappers.lambdaQuery().eq(ReportFileEntity::getName, (Object)this.getFileName(file)));
        byte[] content = reportFileEntity.getContent();
        return new ByteArrayInputStream(content);
    }

    public void deleteReport(String file) {
        this.service.remove((Wrapper)Wrappers.lambdaUpdate().eq(ReportFileEntity::getName, (Object)this.getFileName(file)));
    }

    public List<ReportFile> getReportFiles() {
        List list = this.service.list();
        ArrayList<ReportFile> reportFiles = new ArrayList<ReportFile>();
        list.forEach(reportFileEntity -> reportFiles.add(new ReportFile(reportFileEntity.getName(), reportFileEntity.getUpdateTime())));
        return reportFiles;
    }

    public void saveReport(String file, String content) {
        String fileName = this.getFileName(file);
        ReportFileEntity reportFileEntity = (ReportFileEntity)this.service.getOne((Wrapper)Wrappers.lambdaQuery().eq(ReportFileEntity::getName, (Object)fileName));
        Date now = DateUtil.now();
        if (reportFileEntity == null) {
            reportFileEntity = new ReportFileEntity();
            reportFileEntity.setName(fileName);
            reportFileEntity.setContent(content.getBytes());
            reportFileEntity.setCreateTime(now);
            reportFileEntity.setIsDeleted(0);
        } else {
            reportFileEntity.setContent(content.getBytes());
        }
        reportFileEntity.setUpdateTime(now);
        this.service.saveOrUpdate(reportFileEntity);
    }

    public String getName() {
        return this.properties.getName();
    }

    public boolean disabled() {
        return this.properties.isDisabled();
    }

    public String getPrefix() {
        return this.properties.getPrefix();
    }

    private String getFileName(String name) {
        if (name.startsWith(this.getPrefix())) {
            name = name.substring(this.getPrefix().length());
        }
        return name;
    }

    public DatabaseProvider(ReportDatabaseProperties properties, IReportFileService service) {
        this.properties = properties;
        this.service = service;
    }
}

