/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.ribbon.rule;

import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.AvailabilityPredicate;
import com.netflix.loadbalancer.CompositePredicate;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.PredicateBasedRule;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.springblade.core.ribbon.predicate.DiscoveryEnabledPredicate;
import org.springframework.util.Assert;

public abstract class DiscoveryEnabledRule
extends PredicateBasedRule {
    private final CompositePredicate predicate;

    public DiscoveryEnabledRule(DiscoveryEnabledPredicate discoveryEnabledPredicate) {
        Assert.notNull((Object)((Object)discoveryEnabledPredicate), (String)"Parameter 'discoveryEnabledPredicate' can't be null");
        this.predicate = this.createCompositePredicate(discoveryEnabledPredicate, new AvailabilityPredicate((IRule)this, null));
    }

    public AbstractServerPredicate getPredicate() {
        return this.predicate;
    }

    public Server choose(Object key) {
        ILoadBalancer lb = this.getLoadBalancer();
        List allServers = lb.getAllServers();
        List<Server> serverList = this.filterServers(allServers);
        return (Server)this.getPredicate().chooseRoundRobinAfterFiltering(serverList, key).orNull();
    }

    public abstract List<Server> filterServers(List<Server> var1);

    private CompositePredicate createCompositePredicate(DiscoveryEnabledPredicate discoveryEnabledPredicate, AvailabilityPredicate availabilityPredicate) {
        CompositePredicate.Builder builder = CompositePredicate.withPredicates((AbstractServerPredicate[])new AbstractServerPredicate[]{discoveryEnabledPredicate, availabilityPredicate});
        return builder.build();
    }
}

