/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.ribbon.rule;

import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springblade.core.ribbon.predicate.MetadataAwarePredicate;
import org.springblade.core.ribbon.rule.DiscoveryEnabledRule;
import org.springblade.core.ribbon.support.BladeRibbonRuleProperties;
import org.springblade.core.ribbon.utils.BeanUtil;
import org.springblade.core.ribbon.utils.HostUtil;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

public class MetadataAwareRule
extends DiscoveryEnabledRule {
    public MetadataAwareRule() {
        super(MetadataAwarePredicate.INSTANCE);
    }

    @Override
    public List<Server> filterServers(List<Server> serverList) {
        BladeRibbonRuleProperties ribbonProperties = BeanUtil.getBean(BladeRibbonRuleProperties.class);
        List<String> priorIpPattern = ribbonProperties.getPriorIpPattern();
        String hostIp = HostUtil.getHostIp();
        boolean hasPriorIpPattern = !priorIpPattern.isEmpty();
        String[] priorIpPatterns = priorIpPattern.toArray(new String[0]);
        ArrayList<Server> priorServerList = new ArrayList<Server>();
        for (Server server : serverList) {
            String host = server.getHost();
            if (ObjectUtils.nullSafeEquals((Object)hostIp, (Object)host)) {
                return Collections.singletonList(server);
            }
            if (!hasPriorIpPattern || !PatternMatchUtils.simpleMatch((String[])priorIpPatterns, (String)host)) continue;
            priorServerList.add(server);
        }
        if (!priorServerList.isEmpty()) {
            return priorServerList;
        }
        return Collections.unmodifiableList(serverList);
    }
}

