/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.ribbon.support;

import com.alibaba.cloud.nacos.ribbon.NacosServer;
import org.springblade.core.ribbon.rule.DiscoveryEnabledRule;
import org.springblade.core.ribbon.rule.MetadataAwareRule;
import org.springblade.core.ribbon.support.BladeRibbonRuleProperties;
import org.springblade.core.ribbon.utils.BeanUtil;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnClass(value={NacosServer.class})
@AutoConfigureBefore(value={RibbonClientConfiguration.class})
@EnableConfigurationProperties(value={BladeRibbonRuleProperties.class})
@ConditionalOnProperty(value={"blade.ribbon.rule.enabled"}, havingValue="true")
public class BladeRibbonRuleAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public DiscoveryEnabledRule metadataAwareRule() {
        return new MetadataAwareRule();
    }

    @Bean
    public BeanUtil beanUtil() {
        return new BeanUtil();
    }
}

