/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springblade.core.cache.utils.CacheUtil;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.system.entity.App;
import org.springblade.system.entity.AuthClient;
import org.springblade.system.entity.Dept;
import org.springblade.system.entity.Menu;
import org.springblade.system.entity.Post;
import org.springblade.system.entity.Role;
import org.springblade.system.entity.Tenant;
import org.springblade.system.feign.ISysClient;

public class SysCache {
    private static final String CLIENT_ID = "client:id:";
    private static final String APP_ID = "app:id:";
    private static final String MENU_ID = "menu:id:";
    private static final String DEPT_ID = "dept:id:";
    private static final String DEPT_NAME = "dept:name:";
    private static final String DEPT_NAME_ID = "deptName:id:";
    private static final String DEPT_NAMES_ID = "deptNames:id:";
    private static final String DEPT_CHILD_ID = "deptChild:id:";
    private static final String DEPT_CHILDIDS_ID = "deptChildIds:id:";
    private static final String POST_ID = "post:id:";
    private static final String POST_NAME = "post:name:";
    private static final String POST_NAME_ID = "postName:id:";
    private static final String POST_NAMES_ID = "postNames:id:";
    private static final String ROLE_ID = "role:id:";
    private static final String ROLE_NAME = "role:name:";
    private static final String ROLE_NAME_ID = "roleName:id:";
    private static final String ROLE_NAMES_ID = "roleNames:id:";
    private static final String ROLE_ALIAS_ID = "roleAlias:id:";
    private static final String ROLE_ALIASES_ID = "roleAliases:id:";
    private static final String TENANT_ID = "tenant:id:";
    private static final String TENANT_TENANT_ID = "tenant:tenantId:";
    private static final String USER_ID = "user:id:";
    private static ISysClient sysClient;

    private static ISysClient getSysClient() {
        if (sysClient == null) {
            sysClient = (ISysClient)SpringUtil.getBean(ISysClient.class);
        }
        return sysClient;
    }

    public static AuthClient getClient(String id) {
        return (AuthClient)((Object)CacheUtil.get((String)"blade:sys", (String)CLIENT_ID, (Object)id, () -> {
            R<AuthClient> result = SysCache.getSysClient().getClient(id);
            return (AuthClient)((Object)((Object)result.getData()));
        }));
    }

    public static App getApp(Long appId) {
        return (App)((Object)CacheUtil.get((String)"blade:sys", (String)APP_ID, (Object)appId, () -> {
            R<App> result = SysCache.getSysClient().getApp(appId);
            return (App)((Object)((Object)result.getData()));
        }));
    }

    public static Menu getMenu(Long id) {
        return (Menu)CacheUtil.get((String)"blade:sys", (String)MENU_ID, (Object)id, () -> {
            R<Menu> result = SysCache.getSysClient().getMenu(id);
            return (Menu)result.getData();
        });
    }

    public static Dept getDept(Long id) {
        return (Dept)CacheUtil.get((String)"blade:sys", (String)DEPT_ID, (Object)id, () -> {
            R<Dept> result = SysCache.getSysClient().getDept(id);
            return (Dept)result.getData();
        });
    }

    public static String getDeptIds(String tenantId, String deptNames) {
        return (String)CacheUtil.get((String)"blade:sys", (String)DEPT_NAME, (Object)(tenantId + "-" + deptNames), () -> {
            R<String> result = SysCache.getSysClient().getDeptIds(tenantId, deptNames);
            return (String)result.getData();
        });
    }

    public static String getDeptName(Long id) {
        return (String)CacheUtil.get((String)"blade:sys", (String)DEPT_NAME_ID, (Object)id, () -> {
            R<String> result = SysCache.getSysClient().getDeptName(id);
            return (String)result.getData();
        });
    }

    public static List<String> getDeptNames(String deptIds) {
        return (List)CacheUtil.get((String)"blade:sys", (String)DEPT_NAMES_ID, (Object)deptIds, () -> {
            R<List<String>> result = SysCache.getSysClient().getDeptNames(deptIds);
            return (List)result.getData();
        });
    }

    public static List<Dept> getDeptChild(Long deptId) {
        return (List)CacheUtil.get((String)"blade:sys", (String)DEPT_CHILD_ID, (Object)deptId, () -> {
            R<List<Dept>> result = SysCache.getSysClient().getDeptChild(deptId);
            return (List)result.getData();
        });
    }

    public static List<Long> getDeptChildIds(Long deptId) {
        if (deptId == null) {
            return null;
        }
        ArrayList<Object> deptIdList = (ArrayList<Object>)CacheUtil.get((String)"blade:sys", (String)DEPT_CHILDIDS_ID, (Object)deptId, List.class);
        if (deptIdList == null) {
            deptIdList = new ArrayList<Object>();
            List<Dept> deptChild = SysCache.getDeptChild(deptId);
            if (deptChild != null) {
                List collect = deptChild.stream().map(Dept::getId).collect(Collectors.toList());
                deptIdList.addAll(collect);
            }
            deptIdList.add(deptId);
            CacheUtil.put((String)"blade:sys", (String)DEPT_CHILDIDS_ID, (Object)deptId, deptIdList);
        }
        return deptIdList;
    }

    public static Post getPost(Long id) {
        return (Post)((Object)CacheUtil.get((String)"blade:sys", (String)POST_ID, (Object)id, () -> {
            R<Post> result = SysCache.getSysClient().getPost(id);
            return (Post)((Object)((Object)result.getData()));
        }));
    }

    public static String getPostIds(String tenantId, String postNames) {
        return (String)CacheUtil.get((String)"blade:sys", (String)POST_NAME, (Object)(tenantId + "-" + postNames), () -> {
            R<String> result = SysCache.getSysClient().getPostIds(tenantId, postNames);
            return (String)result.getData();
        });
    }

    public static String getPostName(Long id) {
        return (String)CacheUtil.get((String)"blade:sys", (String)POST_NAME_ID, (Object)id, () -> {
            R<String> result = SysCache.getSysClient().getPostName(id);
            return (String)result.getData();
        });
    }

    public static List<String> getPostNames(String postIds) {
        return (List)CacheUtil.get((String)"blade:sys", (String)POST_NAMES_ID, (Object)postIds, () -> {
            R<List<String>> result = SysCache.getSysClient().getPostNames(postIds);
            return (List)result.getData();
        });
    }

    public static Role getRole(Long id) {
        return (Role)CacheUtil.get((String)"blade:sys", (String)ROLE_ID, (Object)id, () -> {
            R<Role> result = SysCache.getSysClient().getRole(id);
            return (Role)result.getData();
        });
    }

    public static String getRoleIds(String clientId, String tenantId, String roleNames) {
        return (String)CacheUtil.get((String)"blade:sys", (String)ROLE_NAME, (Object)(clientId + "-" + tenantId + "-" + roleNames), () -> {
            R<String> result = SysCache.getSysClient().getRoleIds(clientId, tenantId, roleNames);
            return (String)result.getData();
        });
    }

    public static String getRoleName(Long id) {
        return (String)CacheUtil.get((String)"blade:sys", (String)ROLE_NAME_ID, (Object)id, () -> {
            R<String> result = SysCache.getSysClient().getRoleName(id);
            return (String)result.getData();
        });
    }

    public static String getRoleAlias(Long id) {
        return (String)CacheUtil.get((String)"blade:sys", (String)ROLE_ALIAS_ID, (Object)id, () -> {
            R<String> result = SysCache.getSysClient().getRoleAlias(id);
            return (String)result.getData();
        });
    }

    public static List<String> getRoleNames(String roleIds) {
        return (List)CacheUtil.get((String)"blade:sys", (String)ROLE_NAMES_ID, (Object)roleIds, () -> {
            R<List<String>> result = SysCache.getSysClient().getRoleNames(roleIds);
            return (List)result.getData();
        });
    }

    public static List<String> getRoleAliases(String roleIds) {
        return (List)CacheUtil.get((String)"blade:sys", (String)ROLE_ALIASES_ID, (Object)roleIds, () -> {
            R<List<String>> result = SysCache.getSysClient().getRoleAliases(roleIds);
            return (List)result.getData();
        });
    }

    public static Tenant getTenant(Long id) {
        return (Tenant)((Object)CacheUtil.get((String)"blade:sys", (String)TENANT_ID, (Object)id, () -> {
            R<Tenant> result = SysCache.getSysClient().getTenant(id);
            return (Tenant)((Object)((Object)result.getData()));
        }));
    }

    public static Tenant getTenant(String tenantId) {
        return (Tenant)((Object)CacheUtil.get((String)"blade:sys", (String)TENANT_TENANT_ID, (Object)tenantId, () -> {
            R<Tenant> result = SysCache.getSysClient().getTenant(tenantId);
            return (Tenant)((Object)((Object)result.getData()));
        }));
    }
}

