/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.cache;

import org.springblade.core.cache.utils.CacheUtil;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.system.entity.Region;
import org.springblade.system.feign.ISysClient;

public class RegionCache {
    public static final int PROVINCE_LEVEL = 1;
    public static final int CITY_LEVEL = 2;
    public static final int DISTRICT_LEVEL = 3;
    public static final int TOWN_LEVEL = 4;
    public static final int VILLAGE_LEVEL = 5;
    private static final String REGION_CODE = "region:code:";
    private static ISysClient sysClient;

    private static ISysClient getSysClient() {
        if (sysClient == null) {
            sysClient = (ISysClient)SpringUtil.getBean(ISysClient.class);
        }
        return sysClient;
    }

    public static Region getByCode(String code) {
        return (Region)CacheUtil.get((String)"blade:sys", (String)REGION_CODE, (Object)code, () -> {
            R<Region> result = RegionCache.getSysClient().getRegion(code);
            return (Region)result.getData();
        });
    }
}

