/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.feign;

import java.util.List;
import java.util.Map;
import org.springblade.core.tool.api.R;
import org.springblade.system.entity.App;
import org.springblade.system.entity.AuthClient;
import org.springblade.system.entity.Dept;
import org.springblade.system.entity.Menu;
import org.springblade.system.entity.Param;
import org.springblade.system.entity.ParamBiz;
import org.springblade.system.entity.Post;
import org.springblade.system.entity.Region;
import org.springblade.system.entity.Role;
import org.springblade.system.entity.Tenant;
import org.springblade.system.feign.ISysClientFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="blade-system", fallback=ISysClientFallback.class)
public interface ISysClient {
    public static final String API_PREFIX = "/client";
    public static final String CLIENT = "/client/client";
    public static final String APP = "/client/app";
    public static final String MENU = "/client/menu";
    public static final String DEPT = "/client/dept";
    public static final String DEPT_IDS = "/client/dept-ids";
    public static final String DEPT_NAME = "/client/dept-name";
    public static final String DEPT_NAMES = "/client/dept-names";
    public static final String DEPT_CHILD = "/client/dept-child";
    public static final String DEPT_BY_CATEGORY = "/client/depts-by-category";
    public static final String POST = "/client/post";
    public static final String POST_IDS = "/client/post-ids";
    public static final String POST_NAME = "/client/post-name";
    public static final String POST_NAMES = "/client/post-names";
    public static final String ROLE = "/client/role";
    public static final String ROLE_LIST = "/client/role-list";
    public static final String ROLE_IDS = "/client/role-ids";
    public static final String ROLE_NAME = "/client/role-name";
    public static final String ROLE_NAMES = "/client/role-names";
    public static final String ROLE_ALIAS = "/client/role-alias";
    public static final String ROLE_ALIASES = "/client/role-aliases";
    public static final String TENANT = "/client/tenant";
    public static final String TENANT_ID = "/client/tenant-id";
    public static final String PARAM = "/client/param";
    public static final String PARAM_VALUE = "/client/param-value";
    public static final String PARAM_BIZ = "/client/param-biz";
    public static final String PARAM_BIZ_VALUE = "/client/param-biz-value";
    public static final String PARAM_BIZ_VALUES = "/client/param-biz-values";
    public static final String PARAM_BIZ_VALUE_SIMPLE = "/client/param-biz-value-simple";
    public static final String PARAM_BIZ_VALUES_SIMPLE = "/client/param-biz-values-simple";
    public static final String PARAM_BIZ_VALUE_UPDATE = "/client/update-param-biz-value";
    public static final String REGION = "/client/region";
    public static final String VALIDATE_CAPTCHA = "/client/validate-captcha";
    public static final String QUERY_MEMBER_CUSTOMER_USER = "/client/queryMemberCustomerUser";
    public static final String QUERY_REGION_NUM_CLASH = "/client/queryRegionNumClash";

    @GetMapping(value={"/client/client"})
    public R<AuthClient> getClient(@RequestParam(value="id") String var1);

    @GetMapping(value={"/client/app"})
    public R<App> getApp(@RequestParam(value="appId") Long var1);

    @GetMapping(value={"/client/menu"})
    public R<Menu> getMenu(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/dept"})
    public R<Dept> getDept(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/dept-ids"})
    public R<String> getDeptIds(@RequestParam(value="tenantId") String var1, @RequestParam(value="deptNames") String var2);

    @GetMapping(value={"/client/dept-name"})
    public R<String> getDeptName(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/dept-names"})
    public R<List<String>> getDeptNames(@RequestParam(value="deptIds") String var1);

    @GetMapping(value={"/client/dept-child"})
    public R<List<Dept>> getDeptChild(@RequestParam(value="deptId") Long var1);

    @GetMapping(value={"/client/depts-by-category"})
    public R<List<Dept>> getDeptsByCategory(@RequestParam(value="category") Integer var1);

    @GetMapping(value={"/client/post"})
    public R<Post> getPost(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/post-ids"})
    public R<String> getPostIds(@RequestParam(value="tenantId") String var1, @RequestParam(value="postNames") String var2);

    @GetMapping(value={"/client/post-name"})
    public R<String> getPostName(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/post-names"})
    public R<List<String>> getPostNames(@RequestParam(value="postIds") String var1);

    @GetMapping(value={"/client/role"})
    public R<Role> getRole(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/role-ids"})
    public R<String> getRoleIds(@RequestParam(value="clientId") String var1, @RequestParam(value="tenantId") String var2, @RequestParam(value="roleNames") String var3);

    @GetMapping(value={"/client/role-name"})
    public R<String> getRoleName(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/role-alias"})
    public R<String> getRoleAlias(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/role-names"})
    public R<List<String>> getRoleNames(@RequestParam(value="roleIds") String var1);

    @GetMapping(value={"/client/role-list"})
    public R<List<Role>> getRoles(@RequestParam(value="roleIds") String var1);

    @GetMapping(value={"/client/role-aliases"})
    public R<List<String>> getRoleAliases(@RequestParam(value="roleIds") String var1);

    @GetMapping(value={"/client/tenant"})
    public R<Tenant> getTenant(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/tenant-id"})
    public R<Tenant> getTenant(@RequestParam(value="tenantId") String var1);

    @GetMapping(value={"/client/param"})
    public R<Param> getParam(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/param-value"})
    public R<String> getParamValue(@RequestParam(value="paramKey") String var1);

    @GetMapping(value={"/client/param-biz"})
    public R<ParamBiz> getParamBiz(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/param-biz-value-simple"})
    public R<String> getParamBizValue(@RequestParam(value="paramKey") String var1);

    @GetMapping(value={"/client/param-biz-values-simple"})
    public R<Map<String, String>> getParamBizValues(@RequestParam(value="paramKeys") String var1);

    @GetMapping(value={"/client/param-biz-value"})
    public R<String> getParamBizValue(@RequestParam(value="tenantId") String var1, @RequestParam(value="clientId") String var2, @RequestParam(value="paramKey") String var3);

    @GetMapping(value={"/client/param-biz-values"})
    public R<Map<String, String>> getParamBizValues(@RequestParam(value="tenantId") String var1, @RequestParam(value="clientId") String var2, @RequestParam(value="paramKeys") String var3);

    @PostMapping(value={"/client/update-param-biz-value"})
    public R updateParamBizValue(@RequestParam(value="paramKey") String var1, @RequestParam(value="paramValue") String var2);

    @GetMapping(value={"/client/region"})
    public R<Region> getRegion(@RequestParam(value="code") String var1);

    @GetMapping(value={"/client/validate-captcha"})
    public R<Boolean> validateCaptchaResult(@RequestParam(value="ticket") String var1, @RequestParam(value="randStr") String var2, @RequestParam(value="userIp") String var3);

    @GetMapping(value={"/client/queryMemberCustomerUser"})
    public R<Long> queryMemberCustomerUser(@RequestParam(value="memberId") Long var1);

    @GetMapping(value={"/client/queryRegionNumClash"})
    public R<Boolean> queryRegionNumClash(@RequestParam(value="userId") Long var1, @RequestParam(value="startNum") Integer var2, @RequestParam(value="endNum") Integer var3);
}

