/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.user.feign;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import java.util.Map;
import org.springblade.core.tool.api.R;
import org.springblade.system.user.entity.FrontUser;
import org.springblade.system.user.entity.FrontUserInfo;
import org.springblade.system.user.entity.UserOauth;
import org.springblade.system.user.vo.UserVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="blade-user")
public interface IFrontUserClient {
    public static final String API_PREFIX = "/client/front";
    public static final String USER_INFO = "/client/front/user-info";
    public static final String USER_INFO_LAST_REGISTER = "/client/front/userInfoLastRegister";
    public static final String USER_INFO_BY_TYPE = "/client/front/user-info-by-type";
    public static final String USER_INFO_BY_ID = "/client/front/user-info-by-id";
    public static final String USER_INFO_BY_ACCOUNT = "/client/front/user-info-by-account";
    public static final String USER_INFO_BY_MOBILE = "/client/front/user-info-by-mobile";
    public static final String USER_AUTH_INFO = "/client/front/user-auth-info";
    public static final String SAVE_USER = "/client/front/save-user";
    public static final String REMOVE_USER = "/client/front/remove-user";
    public static final String USER_PAGE = "/client/front/page";
    public static final String USER_LIST = "/client/front/list";
    public static final String USER_LIST_BY_TENANT = "/client/front/list-by-tenant";
    public static final String USER_DETAIL = "/client/front/detail";
    public static final String UPDATE_USER = "/client/front/update-user";
    public static final String REGISTER_USER = "/client/front/register-user";
    public static final String UPDATE_USER_PASSWORD = "/client/front/update-user-password";
    public static final String CHANGE_STATUS = "/client/front/change-status";
    public static final String LOGIN_SUCCESS = "/client/front/login-success";
    public static final String LOGIN_FAILURE = "/client/front/login-failure";
    public static final String STAFF_LIST = "/client/front/staff";
    public static final String USER_INFO_LIST = "/client/front/user-info-list";
    public static final String USER_INFO_BY_NAME = "/client/front/user-info-by-name";
    public static final String USER_INFO_BY_PHONE = "/client/front/user-info-by-phone";
    public static final String USER_INFO_LIST_POST = "/client/front/post_user-info-list";
    public static final String USER_INFO_BY_ACCOUNT_SRM = "/client/front/user-info-by-account-srm";

    @GetMapping(value={"/client/front/user-info-by-id"})
    public R<FrontUser> userInfoById(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"/client/front/userInfoLastRegister"})
    public R<FrontUser> userInfoLastRegister();

    @GetMapping(value={"/client/front/user-info-by-account"})
    public R<FrontUser> userByAccount(@RequestParam(value="tenantId") String var1, @RequestParam(value="account") String var2);

    @GetMapping(value={"/client/front/user-info-by-mobile"})
    public R<FrontUserInfo> userByMobile(@RequestParam(value="clientId") String var1, @RequestParam(value="tenantId") String var2, @RequestParam(value="mobile") String var3);

    @GetMapping(value={"/client/front/user-info"})
    public R<FrontUserInfo> userInfo(@RequestParam(value="clientId") String var1, @RequestParam(value="tenantId") String var2, @RequestParam(value="account") String var3);

    @GetMapping(value={"/client/front/user-info-by-type"})
    public R<FrontUserInfo> userInfo(@RequestParam(value="clientId") String var1, @RequestParam(value="tenantId") String var2, @RequestParam(value="account") String var3, @RequestParam(value="userType") String var4);

    @PostMapping(value={"/client/front/user-auth-info"})
    public R<FrontUserInfo> userAuthInfo(@RequestBody UserOauth var1);

    @PostMapping(value={"/client/front/save-user"})
    public R<Boolean> saveUser(@RequestBody FrontUser var1);

    @PostMapping(value={"/client/front/remove-user"})
    public R<Boolean> removeUser(@RequestParam(value="tenantIds") String var1);

    @GetMapping(value={"/client/front/page"})
    public R<IPage<UserVO>> page(@SpringQueryMap FrontUser var1, @RequestParam Integer var2, @RequestParam Integer var3, @RequestParam(required=false) String var4, @RequestParam(required=false) String var5, @RequestParam(required=false) Long var6);

    @GetMapping(value={"/client/front/list"})
    public R<List<UserVO>> list(@SpringQueryMap FrontUser var1, @RequestParam(required=false) String var2, @RequestParam(required=false) String var3, @RequestParam(required=false) Long var4);

    @GetMapping(value={"/client/front/list-by-tenant"})
    public R<List<UserVO>> listByTenant(@SpringQueryMap FrontUser var1, @RequestParam(required=false) String var2, @RequestParam(required=false) String var3, @RequestParam(required=false) Long var4, @RequestParam String var5);

    @GetMapping(value={"/client/front/detail"})
    public R<UserVO> detail(@RequestParam String var1, @RequestParam Long var2);

    @PutMapping(value={"/client/front/update-user"})
    public R<Boolean> updateUser(@RequestBody FrontUser var1);

    @PostMapping(value={"/client/front/register-user"})
    public R<FrontUser> registerUser(@RequestBody FrontUser var1);

    @PutMapping(value={"/client/front/update-user-password"})
    public R<Boolean> updateUserPassword(@RequestBody FrontUser var1);

    @PutMapping(value={"/client/front/change-status"})
    public R<Boolean> changeStatus(@RequestParam String var1, @RequestParam Integer var2);

    @PutMapping(value={"/client/front/login-success"})
    public R<Boolean> loginSuccess(@RequestParam Long var1, @RequestParam String var2);

    @PutMapping(value={"/client/front/login-failure"})
    public R<Boolean> loginFailure(@RequestParam String var1, @RequestParam String var2, @RequestParam String var3);

    @PutMapping(value={"/client/front/staff"})
    public R<List<UserVO>> staffList(@RequestBody List<Long> var1);

    @GetMapping(value={"/client/front/user-info-list"})
    public R<Map<Long, FrontUser>> getUserListByIds(@RequestParam(value="userIds") Long[] var1);

    @PostMapping(value={"/client/front/post_user-info-list"})
    public R<Map<Long, FrontUser>> getPostUserListByIds(@RequestParam(value="userIds") Long[] var1);

    @GetMapping(value={"/client/front/user-info-by-name"})
    public R<List<FrontUser>> getUserListByName(@RequestParam(value="fullName") String var1);

    @GetMapping(value={"/client/front/user-info-by-phone"})
    public R<FrontUser> getUserByPhone(@RequestParam(value="phone") String var1);

    @GetMapping(value={"/client/front/user-info-by-account-srm"})
    public R<FrontUser> userByAccountSrm(@RequestParam(value="tenantId") String var1, @RequestParam(value="account") String var2);
}

