/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.retry;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.util.Assert;

public class RepublishMessageRecoverer
implements MessageRecoverer {
    public static final String X_EXCEPTION_STACKTRACE = "x-exception-stacktrace";
    public static final String X_EXCEPTION_MESSAGE = "x-exception-message";
    public static final String X_ORIGINAL_EXCHANGE = "x-original-exchange";
    public static final String X_ORIGINAL_ROUTING_KEY = "x-original-routingKey";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final AmqpTemplate errorTemplate;
    protected final String errorRoutingKey;
    protected final String errorExchangeName;
    private String errorRoutingKeyPrefix = "error.";
    private MessageDeliveryMode deliveryMode = MessageDeliveryMode.PERSISTENT;

    public RepublishMessageRecoverer(AmqpTemplate errorTemplate) {
        this(errorTemplate, null, null);
    }

    public RepublishMessageRecoverer(AmqpTemplate errorTemplate, String errorExchange) {
        this(errorTemplate, errorExchange, null);
    }

    public RepublishMessageRecoverer(AmqpTemplate errorTemplate, String errorExchange, String errorRoutingKey) {
        Assert.notNull((Object)errorTemplate, (String)"'errorTemplate' cannot be null");
        this.errorTemplate = errorTemplate;
        this.errorExchangeName = errorExchange;
        this.errorRoutingKey = errorRoutingKey;
    }

    public RepublishMessageRecoverer errorRoutingKeyPrefix(String errorRoutingKeyPrefix) {
        this.setErrorRoutingKeyPrefix(errorRoutingKeyPrefix);
        return this;
    }

    public void setErrorRoutingKeyPrefix(String errorRoutingKeyPrefix) {
        Assert.notNull((Object)errorRoutingKeyPrefix, (String)"'errorRoutingKeyPrefix' cannot be null");
        this.errorRoutingKeyPrefix = errorRoutingKeyPrefix;
    }

    protected String getErrorRoutingKeyPrefix() {
        return this.errorRoutingKeyPrefix;
    }

    public void setDeliveryMode(MessageDeliveryMode deliveryMode) {
        Assert.notNull((Object)deliveryMode, (String)"'deliveryMode' cannot be null");
        this.deliveryMode = deliveryMode;
    }

    protected MessageDeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    @Override
    public void recover(Message message, Throwable cause) {
        MessageProperties messageProperties = message.getMessageProperties();
        Map headers = messageProperties.getHeaders();
        headers.put(X_EXCEPTION_STACKTRACE, this.getStackTraceAsString(cause));
        headers.put(X_EXCEPTION_MESSAGE, cause.getCause() != null ? cause.getCause().getMessage() : cause.getMessage());
        headers.put(X_ORIGINAL_EXCHANGE, messageProperties.getReceivedExchange());
        headers.put(X_ORIGINAL_ROUTING_KEY, messageProperties.getReceivedRoutingKey());
        Map<? extends String, ? extends Object> additionalHeaders = this.additionalHeaders(message, cause);
        if (additionalHeaders != null) {
            headers.putAll(additionalHeaders);
        }
        if (messageProperties.getDeliveryMode() == null) {
            messageProperties.setDeliveryMode(this.deliveryMode);
        }
        if (null != this.errorExchangeName) {
            String routingKey = this.errorRoutingKey != null ? this.errorRoutingKey : this.prefixedOriginalRoutingKey(message);
            this.errorTemplate.send(this.errorExchangeName, routingKey, message);
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Republishing failed message to exchange " + this.errorExchangeName));
            }
        } else {
            String routingKey = this.prefixedOriginalRoutingKey(message);
            this.errorTemplate.send(routingKey, message);
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Republishing failed message to the template's default exchange with routing key " + routingKey));
            }
        }
    }

    protected Map<? extends String, ? extends Object> additionalHeaders(Message message, Throwable cause) {
        return null;
    }

    private String prefixedOriginalRoutingKey(Message message) {
        return this.errorRoutingKeyPrefix + message.getMessageProperties().getReceivedRoutingKey();
    }

    private String getStackTraceAsString(Throwable cause) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        cause.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }
}

