/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import com.rabbitmq.client.Channel;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.BatchMessageListener;
import org.springframework.amqp.core.Declarables;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.batch.BatchingStrategy;
import org.springframework.amqp.rabbit.batch.SimpleBatchingStrategy;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.connection.RoutingConnectionFactory;
import org.springframework.amqp.rabbit.listener.ConditionalRejectingErrorHandler;
import org.springframework.amqp.rabbit.listener.ListenerContainerConsumerFailedEvent;
import org.springframework.amqp.rabbit.listener.ListenerContainerConsumerTerminatedEvent;
import org.springframework.amqp.rabbit.listener.ListenerContainerIdleEvent;
import org.springframework.amqp.rabbit.listener.MessageAckListener;
import org.springframework.amqp.rabbit.listener.MicrometerHolder;
import org.springframework.amqp.rabbit.listener.MissingQueueEvent;
import org.springframework.amqp.rabbit.listener.ObservableListenerContainer;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareBatchMessageListener;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerExecutionException;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerStartupException;
import org.springframework.amqp.rabbit.listener.exception.MessageRejectedWhileStoppingException;
import org.springframework.amqp.rabbit.listener.support.ContainerUtils;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.micrometer.RabbitListenerObservation;
import org.springframework.amqp.rabbit.support.micrometer.RabbitListenerObservationConvention;
import org.springframework.amqp.rabbit.support.micrometer.RabbitMessageReceiverContext;
import org.springframework.amqp.support.ConditionalExceptionLogger;
import org.springframework.amqp.support.ConsumerTagStrategy;
import org.springframework.amqp.support.postprocessor.MessagePostProcessorUtils;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;
import org.springframework.util.StringUtils;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

public abstract class AbstractMessageListenerContainer
extends ObservableListenerContainer
implements ApplicationEventPublisherAware {
    private static final int EXIT_99 = 99;
    private static final String UNCHECKED = "unchecked";
    static final int DEFAULT_FAILED_DECLARATION_RETRY_INTERVAL = 5000;
    public static final boolean DEFAULT_DEBATCHING_ENABLED = true;
    public static final int DEFAULT_PREFETCH_COUNT = 250;
    public static final long DEFAULT_RECOVERY_INTERVAL = 5000L;
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 5000L;
    protected final Lock lifecycleLock = new ReentrantLock();
    private final ContainerDelegate delegate = this::actualInvokeListener;
    protected final Lock consumersLock = new ReentrantLock();
    private final Map<String, Object> consumerArgs = new HashMap<String, Object>();
    private final AtomicBoolean logDeclarationException = new AtomicBoolean(true);
    protected final AtomicBoolean stopNow = new AtomicBoolean();
    private ContainerDelegate proxy = this.delegate;
    private long shutdownTimeout = 5000L;
    private ApplicationEventPublisher applicationEventPublisher;
    @Nullable
    private PlatformTransactionManager transactionManager;
    private TransactionAttribute transactionAttribute = new DefaultTransactionAttribute();
    private Executor taskExecutor = new SimpleAsyncTaskExecutor();
    private boolean taskExecutorSet;
    private BackOff recoveryBackOff = new FixedBackOff(5000L, Long.MAX_VALUE);
    private MessagePropertiesConverter messagePropertiesConverter = new DefaultMessagePropertiesConverter();
    private AmqpAdmin amqpAdmin;
    private boolean missingQueuesFatal = true;
    private boolean missingQueuesFatalSet;
    private boolean possibleAuthenticationFailureFatal = true;
    private boolean possibleAuthenticationFailureFatalSet;
    private boolean autoDeclare = true;
    private boolean mismatchedQueuesFatal = false;
    private long failedDeclarationRetryInterval = 5000L;
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private volatile boolean active = false;
    private volatile boolean running = false;
    private ErrorHandler errorHandler = new ConditionalRejectingErrorHandler();
    private boolean exposeListenerChannel = true;
    private MessageListener messageListener;
    private AcknowledgeMode acknowledgeMode = AcknowledgeMode.AUTO;
    private boolean deBatchingEnabled = true;
    private boolean initialized;
    private Collection<MessagePostProcessor> afterReceivePostProcessors;
    private Advice[] adviceChain = new Advice[0];
    @Nullable
    private ConsumerTagStrategy consumerTagStrategy;
    private boolean exclusive;
    private boolean noLocal;
    private boolean defaultRequeueRejected = true;
    private int prefetchCount = 250;
    private boolean globalQos;
    private long idleEventInterval;
    private long lastReceive = System.currentTimeMillis();
    private boolean statefulRetryFatalWithNullMessageId = true;
    private ConditionalExceptionLogger exclusiveConsumerExceptionLogger = new DefaultExclusiveConsumerLogger();
    private boolean alwaysRequeueWithTxManagerRollback;
    private String lookupKeyQualifier = "";
    private boolean forceCloseChannel = true;
    private String errorHandlerLoggerName = this.getClass().getName();
    private BatchingStrategy batchingStrategy = new SimpleBatchingStrategy(0, 0, 0L);
    private boolean isBatchListener;
    private long consumeDelay;
    private JavaLangErrorHandler javaLangErrorHandler = error -> System.exit(99);
    private volatile List<Queue> queues = new CopyOnWriteArrayList<Queue>();
    private volatile boolean lazyLoad;
    private boolean asyncReplies;
    private MessageAckListener messageAckListener = (success, deliveryTag, cause) -> {};
    @Nullable
    private RabbitListenerObservationConvention observationConvention;
    private boolean forceStop;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Nullable
    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public final void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public AcknowledgeMode getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    @Override
    public void setQueueNames(String ... queueName) {
        Assert.noNullElements((Object[])queueName, (String)"Queue name(s) cannot be null");
        this.setQueues((Queue[])Arrays.stream(queueName).map(Queue::new).toArray(Queue[]::new));
    }

    public final void setQueues(Queue ... queues) {
        Assert.notNull((Object)queues, (String)"'queues' cannot be null");
        Assert.noNullElements((Object[])queues, (String)"'queues' cannot contain null elements");
        if (this.isRunning()) {
            for (Queue queue : queues) {
                Assert.isTrue((boolean)StringUtils.hasText((String)queue.getName()), (String)"Cannot add broker-named queues dynamically");
            }
        }
        this.queues = new CopyOnWriteArrayList<Queue>(queues);
    }

    public String[] getQueueNames() {
        return this.queuesToNames().toArray(new String[0]);
    }

    protected Set<String> getQueueNamesAsSet() {
        return new HashSet<String>(this.queuesToNames());
    }

    protected Map<String, Queue> getQueueNamesToQueues() {
        return this.queues.stream().collect(Collectors.toMap(Queue::getActualName, q -> q));
    }

    private List<String> queuesToNames() {
        return this.queues.stream().map(Queue::getActualName).toList();
    }

    public void addQueueNames(String ... queueNames) {
        Assert.notNull((Object)queueNames, (String)"'queueNames' cannot be null");
        Assert.noNullElements((Object[])queueNames, (String)"'queueNames' cannot contain null elements");
        this.addQueues((Queue[])Arrays.stream(queueNames).map(Queue::new).toArray(Queue[]::new));
    }

    public void addQueues(Queue ... queues) {
        Assert.notNull((Object)queues, (String)"'queues' cannot be null");
        Assert.noNullElements((Object[])queues, (String)"'queues' cannot contain null elements");
        if (this.isRunning()) {
            for (Queue queue : queues) {
                Assert.hasText((String)queue.getName(), (String)"Cannot add broker-named queues dynamically");
            }
        }
        this.queues.addAll(Arrays.asList(queues));
    }

    public boolean removeQueueNames(String ... queueNames) {
        Assert.notNull((Object)queueNames, (String)"'queueNames' cannot be null");
        Assert.noNullElements((Object[])queueNames, (String)"'queueNames' cannot contain null elements");
        if (!this.queues.isEmpty()) {
            HashSet<String> toRemove = new HashSet<String>(Arrays.asList(queueNames));
            return this.queues.removeIf(q -> toRemove.contains(q.getActualName()));
        }
        return false;
    }

    public boolean removeQueues(Queue ... queues) {
        Assert.notNull((Object)queues, (String)"'queues' cannot be null");
        Assert.noNullElements((Object[])queues, (String)"'queues' cannot contain null elements");
        return this.removeQueueNames((String[])Arrays.stream(queues).map(Queue::getActualName).toArray(String[]::new));
    }

    public boolean isExposeListenerChannel() {
        return this.exposeListenerChannel;
    }

    public void setExposeListenerChannel(boolean exposeListenerChannel) {
        this.exposeListenerChannel = exposeListenerChannel;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
        this.isBatchListener = messageListener instanceof BatchMessageListener || messageListener instanceof ChannelAwareBatchMessageListener;
        this.asyncReplies = messageListener.isAsyncReplies();
    }

    protected void checkMessageListener(Object listener) {
        if (!(listener instanceof MessageListener)) {
            throw new IllegalArgumentException("Message listener needs to be of type [" + MessageListener.class.getName() + "] or [" + ChannelAwareMessageListener.class.getName() + "]");
        }
    }

    @Nullable
    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setDeBatchingEnabled(boolean deBatchingEnabled) {
        this.deBatchingEnabled = deBatchingEnabled;
    }

    protected boolean isDeBatchingEnabled() {
        return this.deBatchingEnabled;
    }

    public void setAdviceChain(Advice ... adviceChain) {
        Assert.notNull((Object)adviceChain, (String)"'adviceChain' cannot be null");
        this.adviceChain = Arrays.copyOf(adviceChain, adviceChain.length);
    }

    protected Advice[] getAdviceChain() {
        return this.adviceChain;
    }

    public void setAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        Assert.notNull((Object)afterReceivePostProcessors, (String)"'afterReceivePostProcessors' cannot be null");
        Assert.noNullElements((Object[])afterReceivePostProcessors, (String)"'afterReceivePostProcessors' cannot have null elements");
        this.afterReceivePostProcessors = MessagePostProcessorUtils.sort(Arrays.asList(afterReceivePostProcessors));
    }

    public void addAfterReceivePostProcessors(MessagePostProcessor ... postprocessors) {
        Assert.notNull((Object)postprocessors, (String)"'afterReceivePostProcessors' cannot be null");
        if (this.afterReceivePostProcessors == null) {
            this.afterReceivePostProcessors = new ArrayList<MessagePostProcessor>();
        }
        this.afterReceivePostProcessors.addAll(Arrays.asList(postprocessors));
        this.afterReceivePostProcessors = MessagePostProcessorUtils.sort(this.afterReceivePostProcessors);
    }

    public boolean removeAfterReceivePostProcessor(MessagePostProcessor afterReceivePostProcessor) {
        Assert.notNull((Object)afterReceivePostProcessor, (String)"'afterReceivePostProcessor' cannot be null");
        if (this.afterReceivePostProcessors != null) {
            return this.afterReceivePostProcessors.remove(afterReceivePostProcessor);
        }
        return false;
    }

    @Override
    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        RoutingConnectionFactory rcf;
        ConnectionFactory targetConnectionFactory;
        ConnectionFactory connectionFactory = super.getConnectionFactory();
        if (connectionFactory instanceof RoutingConnectionFactory && (targetConnectionFactory = (rcf = (RoutingConnectionFactory)((Object)connectionFactory)).getTargetConnectionFactory(this.getRoutingLookupKey())) != null) {
            return targetConnectionFactory;
        }
        return connectionFactory;
    }

    public void setLookupKeyQualifier(String lookupKeyQualifier) {
        this.lookupKeyQualifier = lookupKeyQualifier;
    }

    protected boolean isForceCloseChannel() {
        return this.forceCloseChannel;
    }

    public void setForceCloseChannel(boolean forceCloseChannel) {
        this.forceCloseChannel = forceCloseChannel;
    }

    @Nullable
    protected String getRoutingLookupKey() {
        return super.getConnectionFactory() instanceof RoutingConnectionFactory ? this.lookupKeyQualifier + this.queuesAsListString() : null;
    }

    private String queuesAsListString() {
        return "[" + this.queues.stream().map(Queue::getName).collect(Collectors.joining(",")) + "]";
    }

    @Nullable
    protected RoutingConnectionFactory getRoutingConnectionFactory() {
        RoutingConnectionFactory rcf;
        ConnectionFactory connectionFactory = super.getConnectionFactory();
        return connectionFactory instanceof RoutingConnectionFactory ? (rcf = (RoutingConnectionFactory)((Object)connectionFactory)) : null;
    }

    public void setConsumerTagStrategy(ConsumerTagStrategy consumerTagStrategy) {
        this.consumerTagStrategy = consumerTagStrategy;
    }

    @Nullable
    protected ConsumerTagStrategy getConsumerTagStrategy() {
        return this.consumerTagStrategy;
    }

    public void setConsumerArguments(Map<String, Object> args) {
        this.consumersLock.lock();
        try {
            this.consumerArgs.clear();
            this.consumerArgs.putAll(args);
        }
        finally {
            this.consumersLock.unlock();
        }
    }

    public Map<String, Object> getConsumerArguments() {
        this.consumersLock.lock();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(this.consumerArgs);
            return hashMap;
        }
        finally {
            this.consumersLock.unlock();
        }
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    protected boolean isExclusive() {
        return this.exclusive;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    protected boolean isNoLocal() {
        return this.noLocal;
    }

    public void setDefaultRequeueRejected(boolean defaultRequeueRejected) {
        this.defaultRequeueRejected = defaultRequeueRejected;
    }

    protected boolean isDefaultRequeueRejected() {
        return this.defaultRequeueRejected;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    protected int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setGlobalQos(boolean globalQos) {
        this.globalQos = globalQos;
    }

    protected boolean isGlobalQos() {
        return this.globalQos;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    protected long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setIdleEventInterval(long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    protected long getIdleEventInterval() {
        return this.idleEventInterval;
    }

    protected long getLastReceive() {
        return this.lastReceive;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Nullable
    protected PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        Assert.notNull((Object)transactionAttribute, (String)"'transactionAttribute' cannot be null");
        this.transactionAttribute = transactionAttribute;
    }

    protected TransactionAttribute getTransactionAttribute() {
        return this.transactionAttribute;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"'taskExecutor' cannot be null");
        this.taskExecutor = taskExecutor;
        this.taskExecutorSet = true;
    }

    protected Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryBackOff = new FixedBackOff(recoveryInterval, Long.MAX_VALUE);
    }

    public void setRecoveryBackOff(BackOff recoveryBackOff) {
        Assert.notNull((Object)recoveryBackOff, (String)"'recoveryBackOff' must not be null.");
        this.recoveryBackOff = recoveryBackOff;
    }

    protected BackOff getRecoveryBackOff() {
        return this.recoveryBackOff;
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        Assert.notNull((Object)messagePropertiesConverter, (String)"messagePropertiesConverter must not be null");
        this.messagePropertiesConverter = messagePropertiesConverter;
    }

    protected MessagePropertiesConverter getMessagePropertiesConverter() {
        return this.messagePropertiesConverter;
    }

    @Nullable
    protected AmqpAdmin getAmqpAdmin() {
        return this.amqpAdmin;
    }

    public void setAmqpAdmin(AmqpAdmin amqpAdmin) {
        this.amqpAdmin = amqpAdmin;
    }

    public void setMissingQueuesFatal(boolean missingQueuesFatal) {
        this.missingQueuesFatal = missingQueuesFatal;
        this.missingQueuesFatalSet = true;
    }

    protected boolean isMissingQueuesFatal() {
        return this.missingQueuesFatal;
    }

    protected boolean isMissingQueuesFatalSet() {
        return this.missingQueuesFatalSet;
    }

    public void setMismatchedQueuesFatal(boolean mismatchedQueuesFatal) {
        this.mismatchedQueuesFatal = mismatchedQueuesFatal;
    }

    protected boolean isMismatchedQueuesFatal() {
        return this.mismatchedQueuesFatal;
    }

    public void setPossibleAuthenticationFailureFatal(boolean possibleAuthenticationFailureFatal) {
        this.doSetPossibleAuthenticationFailureFatal(possibleAuthenticationFailureFatal);
        this.possibleAuthenticationFailureFatalSet = true;
    }

    protected final void doSetPossibleAuthenticationFailureFatal(boolean possibleAuthenticationFailureFatal) {
        this.possibleAuthenticationFailureFatal = possibleAuthenticationFailureFatal;
    }

    public boolean isPossibleAuthenticationFailureFatal() {
        return this.possibleAuthenticationFailureFatal;
    }

    protected boolean isPossibleAuthenticationFailureFatalSet() {
        return this.possibleAuthenticationFailureFatalSet;
    }

    protected boolean isAsyncReplies() {
        return this.asyncReplies;
    }

    public void setAutoDeclare(boolean autoDeclare) {
        this.autoDeclare = autoDeclare;
    }

    protected boolean isAutoDeclare() {
        return this.autoDeclare;
    }

    public void setFailedDeclarationRetryInterval(long failedDeclarationRetryInterval) {
        this.failedDeclarationRetryInterval = failedDeclarationRetryInterval;
    }

    protected long getFailedDeclarationRetryInterval() {
        return this.failedDeclarationRetryInterval;
    }

    protected boolean isStatefulRetryFatalWithNullMessageId() {
        return this.statefulRetryFatalWithNullMessageId;
    }

    public void setStatefulRetryFatalWithNullMessageId(boolean statefulRetryFatalWithNullMessageId) {
        this.statefulRetryFatalWithNullMessageId = statefulRetryFatalWithNullMessageId;
    }

    public void setExclusiveConsumerExceptionLogger(ConditionalExceptionLogger exclusiveConsumerExceptionLogger) {
        this.exclusiveConsumerExceptionLogger = exclusiveConsumerExceptionLogger;
    }

    protected ConditionalExceptionLogger getExclusiveConsumerExceptionLogger() {
        return this.exclusiveConsumerExceptionLogger;
    }

    public void setAlwaysRequeueWithTxManagerRollback(boolean alwaysRequeueWithTxManagerRollback) {
        this.alwaysRequeueWithTxManagerRollback = alwaysRequeueWithTxManagerRollback;
    }

    protected boolean isAlwaysRequeueWithTxManagerRollback() {
        return this.alwaysRequeueWithTxManagerRollback;
    }

    public void setErrorHandlerLoggerName(String errorHandlerLoggerName) {
        Assert.notNull((Object)errorHandlerLoggerName, (String)"'errorHandlerLoggerName' cannot be null");
        this.errorHandlerLoggerName = errorHandlerLoggerName;
    }

    public void setBatchingStrategy(BatchingStrategy batchingStrategy) {
        Assert.notNull((Object)batchingStrategy, (String)"'batchingStrategy' cannot be null");
        this.batchingStrategy = batchingStrategy;
    }

    protected BatchingStrategy getBatchingStrategy() {
        return this.batchingStrategy;
    }

    protected Collection<MessagePostProcessor> getAfterReceivePostProcessors() {
        return this.afterReceivePostProcessors;
    }

    public void setObservationConvention(RabbitListenerObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }

    protected long getConsumeDelay() {
        return this.consumeDelay;
    }

    public void setConsumeDelay(long consumeDelay) {
        this.consumeDelay = consumeDelay;
    }

    protected JavaLangErrorHandler getJavaLangErrorHandler() {
        return this.javaLangErrorHandler;
    }

    public void setjavaLangErrorHandler(JavaLangErrorHandler javaLangErrorHandler) {
        Assert.notNull((Object)javaLangErrorHandler, (String)"'javaLangErrorHandler' cannot be null");
        this.javaLangErrorHandler = javaLangErrorHandler;
    }

    public void setMessageAckListener(MessageAckListener messageAckListener) {
        Assert.notNull((Object)messageAckListener, (String)"'messageAckListener' cannot be null");
        this.messageAckListener = messageAckListener;
    }

    protected MessageAckListener getMessageAckListener() {
        return this.messageAckListener;
    }

    protected boolean isForceStop() {
        return this.forceStop;
    }

    public void setForceStop(boolean forceStop) {
        this.forceStop = forceStop;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.state((this.exposeListenerChannel || !this.getAcknowledgeMode().isManual() ? 1 : 0) != 0, (String)"You cannot acknowledge messages manually if the channel is not exposed to the listener (please check your configuration and set exposeListenerChannel=true or acknowledgeMode!=MANUAL)");
        Assert.state((!this.getAcknowledgeMode().isAutoAck() || !this.isChannelTransacted() ? 1 : 0) != 0, (String)"The acknowledgeMode is NONE (autoack in Rabbit terms) which is not consistent with having a transactional channel. Either use a different AcknowledgeMode or make sure channelTransacted=false");
        this.validateConfiguration();
        this.initialize();
        this.checkMicrometer();
        if (this.isAsyncReplies() && !AcknowledgeMode.MANUAL.equals((Object)this.acknowledgeMode)) {
            this.acknowledgeMode = AcknowledgeMode.MANUAL;
        }
    }

    @Override
    public void setupMessageListener(MessageListener messageListener) {
        this.setMessageListener(messageListener);
    }

    protected void validateConfiguration() {
    }

    protected void initializeProxy(Object delegate) {
        if (this.getAdviceChain().length == 0) {
            return;
        }
        ProxyFactory factory = new ProxyFactory();
        for (Advice advice : this.getAdviceChain()) {
            factory.addAdvisor((Advisor)new DefaultPointcutAdvisor(advice));
        }
        factory.addInterface(ContainerDelegate.class);
        factory.setTarget(delegate);
        this.proxy = (ContainerDelegate)factory.getProxy(ContainerDelegate.class.getClassLoader());
    }

    @Override
    public void destroy() {
        this.shutdown();
        super.destroy();
    }

    public void initialize() {
        if (!this.initialized) {
            this.lifecycleLock.lock();
            try {
                if (!this.initialized) {
                    this.initializeProxy(this.delegate);
                    this.checkMissingQueuesFatalFromProperty();
                    this.checkPossibleAuthenticationFailureFatalFromProperty();
                    this.doInitialize();
                    if (!this.isExposeListenerChannel() && this.transactionManager != null) {
                        this.logger.warn((Object)"exposeListenerChannel=false is ignored when using a TransactionManager");
                    }
                    if (!this.taskExecutorSet && StringUtils.hasText((String)this.getListenerId())) {
                        this.taskExecutor = new SimpleAsyncTaskExecutor(this.getListenerId() + "-");
                        this.taskExecutorSet = true;
                    }
                    if (this.transactionManager != null && !this.isChannelTransacted()) {
                        this.logger.debug((Object)"The 'channelTransacted' is coerced to 'true', when 'transactionManager' is provided");
                        this.setChannelTransacted(true);
                    }
                    if (this.messageListener != null) {
                        this.messageListener.containerAckMode(this.acknowledgeMode);
                    }
                    this.initialized = true;
                }
            }
            catch (Exception ex) {
                throw this.convertRabbitAccessException(ex);
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }
    }

    public void shutdown() {
        this.shutdown(null);
        this.initialized = false;
    }

    public void shutdown(@Nullable Runnable callback) {
        this.lifecycleLock.lock();
        try {
            if (!this.isActive()) {
                this.logger.debug((Object)"Shutdown ignored - container is not active already");
                if (callback != null) {
                    callback.run();
                }
                return;
            }
            this.active = false;
        }
        finally {
            this.lifecycleLock.unlock();
        }
        this.logger.debug((Object)"Shutting down Rabbit listener container");
        try {
            this.shutdownAndWaitOrCallback(callback);
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            this.setNotRunning();
        }
    }

    protected void setNotRunning() {
        this.lifecycleLock.lock();
        try {
            this.running = false;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected abstract void doInitialize();

    protected void doShutdown() {
        this.shutdownAndWaitOrCallback(null);
    }

    public void stop(Runnable callback) {
        this.shutdown(callback);
    }

    protected void shutdownAndWaitOrCallback(@Nullable Runnable callback) {
    }

    public final boolean isActive() {
        return this.active;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        if (!this.initialized) {
            this.lifecycleLock.lock();
            try {
                if (!this.initialized) {
                    this.afterPropertiesSet();
                }
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }
        this.checkObservation();
        try {
            this.logger.debug((Object)"Starting Rabbit listener container.");
            this.configureAdminIfNeeded();
            this.checkMismatchedQueues();
            this.doStart();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            this.lazyLoad = false;
        }
    }

    protected void doStart() {
        this.lifecycleLock.lock();
        try {
            this.active = true;
            this.running = true;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            this.setNotRunning();
        }
    }

    protected void doStop() {
        this.shutdown();
    }

    public final boolean isRunning() {
        return this.running;
    }

    protected void invokeErrorHandler(Throwable ex) {
        if (this.errorHandler != null) {
            try {
                this.errorHandler.handleError(ex);
            }
            catch (Exception e) {
                LogFactory.getLog((String)this.errorHandlerLoggerName).error((Object)"Execution of Rabbit message listener failed, and the error handler threw an exception", (Throwable)e);
                throw e;
            }
        } else {
            this.logger.warn((Object)"Execution of Rabbit message listener failed, and no ErrorHandler has been set.", ex);
        }
    }

    protected void executeListener(Channel channel, Object data) {
        ObservationRegistry registry = this.getObservationRegistry();
        if (data instanceof Message) {
            Message message = (Message)data;
            Observation observation = RabbitListenerObservation.LISTENER_OBSERVATION.observation(this.observationConvention, RabbitListenerObservation.DefaultRabbitListenerObservationConvention.INSTANCE, () -> new RabbitMessageReceiverContext(message, this.getListenerId()), registry);
            observation.observe(() -> this.executeListenerAndHandleException(channel, data));
        } else {
            this.executeListenerAndHandleException(channel, data);
        }
    }

    protected void executeListenerAndHandleException(Channel channel, Object data) {
        if (!this.isRunning()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Rejecting received message(s) because the listener container has been stopped: " + data));
            }
            throw new MessageRejectedWhileStoppingException();
        }
        Object sample = null;
        MicrometerHolder micrometerHolder = this.getMicrometerHolder();
        if (micrometerHolder != null) {
            sample = micrometerHolder.start();
        }
        try {
            this.doExecuteListener(channel, data);
            if (sample != null) {
                String string;
                if (data instanceof Message) {
                    Message message = (Message)data;
                    string = message.getMessageProperties().getConsumerQueue();
                } else {
                    string = this.queuesAsListString();
                }
                micrometerHolder.success(sample, string);
            }
        }
        catch (RuntimeException ex) {
            Message msg;
            Message message;
            if (sample != null) {
                String string;
                if (data instanceof Message) {
                    message = (Message)data;
                    string = message.getMessageProperties().getConsumerQueue();
                } else {
                    string = this.queuesAsListString();
                }
                micrometerHolder.failure(sample, string, ex.getClass().getSimpleName());
            }
            message = data instanceof Message ? (msg = (Message)data) : (Message)((List)data).get(0);
            this.checkStatefulRetry(ex, message);
            this.handleListenerException(ex);
            throw ex;
        }
    }

    private void checkStatefulRetry(RuntimeException ex, Message message) {
        if (message.getMessageProperties().isFinalRetryForMessageWithNoId()) {
            if (this.statefulRetryFatalWithNullMessageId) {
                throw new FatalListenerExecutionException("Illegal null id in message. Failed to manage retry for message: " + message, ex);
            }
            throw new ListenerExecutionFailedException("Cannot retry message more than once without an ID", (Throwable)new AmqpRejectAndDontRequeueException("Not retryable; rejecting and not requeuing", (Throwable)ex), message);
        }
    }

    private void doExecuteListener(Channel channel, Object data) {
        if (data instanceof Message) {
            Message message = (Message)data;
            if (this.afterReceivePostProcessors != null) {
                for (MessagePostProcessor processor : this.afterReceivePostProcessors) {
                    message = processor.postProcessMessage(message);
                    if (message != null) continue;
                    throw new ImmediateAcknowledgeAmqpException("Message Post Processor returned 'null', discarding message");
                }
            }
            if (this.deBatchingEnabled && this.batchingStrategy.canDebatch(message.getMessageProperties())) {
                this.batchingStrategy.deBatch(message, fragment -> this.invokeListener(channel, fragment));
            } else {
                this.invokeListener(channel, message);
            }
        } else {
            this.invokeListener(channel, data);
        }
    }

    protected void invokeListener(Channel channel, Object data) {
        this.proxy.invokeListener(channel, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actualInvokeListener(Channel channel, Object data) {
        MessageListener listener = this.getMessageListener();
        if (listener instanceof ChannelAwareMessageListener) {
            ChannelAwareMessageListener chaml = (ChannelAwareMessageListener)listener;
            this.doInvokeListener(chaml, channel, data);
        } else if (listener instanceof MessageListener) {
            boolean bindChannel;
            MessageListener msgListener = listener;
            boolean bl = bindChannel = this.isExposeListenerChannel() && this.isChannelLocallyTransacted();
            if (bindChannel) {
                RabbitResourceHolder resourceHolder = new RabbitResourceHolder(channel, false);
                resourceHolder.setSynchronizedWithTransaction(true);
                TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)resourceHolder));
            }
            try {
                this.doInvokeListener(msgListener, data);
            }
            finally {
                if (bindChannel) {
                    TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
                }
            }
        } else {
            if (listener != null) {
                throw new FatalListenerExecutionException("Only MessageListener and SessionAwareMessageListener supported: " + listener);
            }
            throw new FatalListenerExecutionException("No message listener specified - see property 'messageListener'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvokeListener(ChannelAwareMessageListener listener, Channel channel, Object data) {
        Message message = null;
        RabbitResourceHolder resourceHolder = null;
        Channel channelToUse = channel;
        boolean boundHere = false;
        try {
            if (!this.isExposeListenerChannel()) {
                resourceHolder = this.getTransactionalResourceHolder();
                channelToUse = resourceHolder.getChannel();
                if (this.isChannelLocallyTransacted() && !TransactionSynchronizationManager.isActualTransactionActive()) {
                    resourceHolder.setSynchronizedWithTransaction(true);
                    TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)resourceHolder));
                    boundHere = true;
                }
            } else if (this.isChannelLocallyTransacted()) {
                RabbitResourceHolder localResourceHolder = new RabbitResourceHolder(channelToUse, false);
                localResourceHolder.setSynchronizedWithTransaction(true);
                TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)localResourceHolder));
                boundHere = true;
            }
            try {
                if (data instanceof List) {
                    listener.onMessageBatch((List)data, channelToUse);
                } else {
                    message = (Message)data;
                    listener.onMessage(message, channelToUse);
                }
            }
            catch (Exception e) {
                throw this.wrapToListenerExecutionFailedExceptionIfNeeded(e, data);
            }
        }
        finally {
            this.cleanUpAfterInvoke(resourceHolder, channelToUse, boundHere);
        }
    }

    private void cleanUpAfterInvoke(@Nullable RabbitResourceHolder resourceHolder, Channel channelToUse, boolean boundHere) {
        if (resourceHolder != null && boundHere) {
            resourceHolder.setSynchronizedWithTransaction(false);
        }
        ConnectionFactoryUtils.releaseResources(resourceHolder);
        if (boundHere) {
            TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
            if (!this.isExposeListenerChannel() && this.isChannelLocallyTransacted()) {
                RabbitUtils.commitIfNecessary(channelToUse);
            }
        }
    }

    protected void doInvokeListener(MessageListener listener, Object data) {
        Message message = null;
        try {
            if (data instanceof List) {
                listener.onMessageBatch((List)data);
            } else {
                message = (Message)data;
                listener.onMessage(message);
            }
        }
        catch (Exception e) {
            throw this.wrapToListenerExecutionFailedExceptionIfNeeded(e, data);
        }
    }

    protected boolean isChannelLocallyTransacted() {
        return this.isChannelTransacted() && this.transactionManager == null;
    }

    protected void handleListenerException(Throwable ex) {
        if (this.isActive()) {
            this.invokeErrorHandler(ex);
        } else {
            this.logger.debug((Object)"Listener exception after container shutdown", ex);
        }
    }

    protected ListenerExecutionFailedException wrapToListenerExecutionFailedExceptionIfNeeded(Exception e, Object data) {
        if (!(e instanceof ListenerExecutionFailedException)) {
            if (data instanceof List) {
                return new ListenerExecutionFailedException("Listener threw exception", e, ((List)data).toArray(new Message[0]));
            }
            return new ListenerExecutionFailedException("Listener threw exception", e, (Message)data);
        }
        return (ListenerExecutionFailedException)((Object)e);
    }

    protected void publishConsumerFailedEvent(String reason, boolean fatal, @Nullable Throwable t) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)(t == null ? new ListenerContainerConsumerTerminatedEvent(this, reason) : new ListenerContainerConsumerFailedEvent(this, reason, t, fatal)));
        }
    }

    protected void publishMissingQueueEvent(String queue) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new MissingQueueEvent(this, queue));
        }
    }

    protected final void publishIdleContainerEvent(long idleTime) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerContainerIdleEvent(this, idleTime, this.getListenerId(), this.getQueueNames()));
        }
    }

    protected void updateLastReceive() {
        if (this.idleEventInterval > 0L) {
            this.lastReceive = System.currentTimeMillis();
        }
    }

    protected void configureAdminIfNeeded() {
        ApplicationContext applicationContext = this.getApplicationContext();
        if (this.amqpAdmin == null && applicationContext != null) {
            Map admins = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, AmqpAdmin.class, (boolean)false, (boolean)false);
            if (admins.size() == 1) {
                this.amqpAdmin = (AmqpAdmin)admins.values().iterator().next();
            } else {
                if ((this.isAutoDeclare() || this.isMismatchedQueuesFatal()) && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("For 'autoDeclare' and 'mismatchedQueuesFatal' to work, there must be exactly one AmqpAdmin in the context or you must inject one into this container; found: " + admins.size() + " for container " + this.toString()));
                }
                if (this.isMismatchedQueuesFatal()) {
                    throw new IllegalStateException("When 'mismatchedQueuesFatal' is 'true', there must be exactly one AmqpAdmin in the context or you must inject one into this container; found: " + admins.size() + " for container " + this.toString());
                }
            }
        }
    }

    protected void checkMismatchedQueues() {
        if (this.mismatchedQueuesFatal && this.amqpAdmin != null) {
            try {
                this.amqpAdmin.initialize();
            }
            catch (AmqpConnectException e) {
                this.logger.info((Object)"Broker not available; cannot check queue declarations");
            }
            catch (AmqpIOException e) {
                if (RabbitUtils.isMismatchedQueueArgs((Exception)((Object)e))) {
                    throw new FatalListenerStartupException("Mismatched queues", e);
                }
                this.logger.info((Object)("Failed to get connection during start(): " + e));
            }
        } else {
            try {
                Connection connection = this.getConnectionFactory().createConnection();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                this.logger.info((Object)("Broker not available; cannot force queue declarations during start: " + e.getMessage()));
            }
        }
    }

    @Override
    public void lazyLoad() {
        if (this.mismatchedQueuesFatal) {
            if (this.missingQueuesFatal) {
                this.logger.warn((Object)"'mismatchedQueuesFatal' and 'missingQueuesFatal' are ignored during the initial start(), for lazily loaded containers");
            } else {
                this.logger.warn((Object)"'mismatchedQueuesFatal' is ignored during the initial start(), for lazily loaded containers");
            }
        } else if (this.missingQueuesFatal) {
            this.logger.warn((Object)"'missingQueuesFatal' is ignored during the initial start(), for lazily loaded containers");
        }
        this.lazyLoad = true;
    }

    protected void redeclareElementsIfNecessary() {
        block7: {
            this.lifecycleLock.lock();
            try {
                AmqpAdmin admin = this.getAmqpAdmin();
                if (this.lazyLoad || admin == null || !this.isAutoDeclare()) break block7;
                try {
                    this.attemptDeclarations(admin);
                    this.logDeclarationException.set(true);
                }
                catch (Exception e) {
                    if (RabbitUtils.isMismatchedQueueArgs(e)) {
                        throw new FatalListenerStartupException("Mismatched queues", e);
                    }
                    if (this.logDeclarationException.getAndSet(false)) {
                        this.logger.error((Object)"Failed to check/redeclare auto-delete queue(s).", (Throwable)e);
                        break block7;
                    }
                    this.logger.error((Object)"Failed to check/redeclare auto-delete queue(s).");
                }
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }
    }

    private void attemptDeclarations(AmqpAdmin admin) {
        ApplicationContext context = this.getApplicationContext();
        if (context != null) {
            Set<String> queueNames = this.getQueueNamesAsSet();
            LinkedHashSet queues = new LinkedHashSet(context.getBeansOfType(Queue.class, false, false).values());
            Map declarables = context.getBeansOfType(Declarables.class, false, false);
            declarables.values().forEach(dec -> queues.addAll(dec.getDeclarablesByType(Queue.class)));
            admin.getManualDeclarableSet().stream().filter(Queue.class::isInstance).map(Queue.class::cast).forEach(queues::add);
            for (Queue queue : queues) {
                if (!this.isMismatchedQueuesFatal() && (!queueNames.contains(queue.getName()) || admin.getQueueProperties(queue.getName()) != null)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Redeclaring context exchanges, queues, bindings.");
                }
                admin.initialize();
                break;
            }
        }
    }

    protected boolean causeChainHasImmediateAcknowledgeAmqpException(Throwable ex) {
        if (ex instanceof Error) {
            return false;
        }
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            if (cause instanceof ImmediateAcknowledgeAmqpException) {
                return true;
            }
            if (!(cause instanceof AmqpRejectAndDontRequeueException) && !(cause instanceof Error)) continue;
            return false;
        }
        return false;
    }

    protected void prepareHolderForRollback(@Nullable RabbitResourceHolder resourceHolder, RuntimeException exception) {
        if (resourceHolder != null) {
            resourceHolder.setRequeueOnRollback(this.isAlwaysRequeueWithTxManagerRollback() || ContainerUtils.shouldRequeue(this.isDefaultRequeueRejected(), exception, this.logger));
        }
    }

    private void checkMissingQueuesFatalFromProperty() {
        if (!this.isMissingQueuesFatalSet()) {
            try {
                ApplicationContext context = this.getApplicationContext();
                if (context != null) {
                    Properties properties = (Properties)context.getBean("spring.amqp.global.properties", Properties.class);
                    String missingQueuesFatalProperty = properties.getProperty("mlc.missing.queues.fatal");
                    if (!StringUtils.hasText((String)missingQueuesFatalProperty)) {
                        missingQueuesFatalProperty = properties.getProperty("smlc.missing.queues.fatal");
                    }
                    if (StringUtils.hasText((String)missingQueuesFatalProperty)) {
                        this.setMissingQueuesFatal(Boolean.parseBoolean(missingQueuesFatalProperty));
                    }
                }
            }
            catch (BeansException be) {
                this.logger.debug((Object)"No global properties bean");
            }
        }
    }

    private void checkPossibleAuthenticationFailureFatalFromProperty() {
        if (!this.isPossibleAuthenticationFailureFatalSet()) {
            try {
                Properties properties;
                String possibleAuthenticationFailureFatalProperty;
                ApplicationContext context = this.getApplicationContext();
                if (context != null && StringUtils.hasText((String)(possibleAuthenticationFailureFatalProperty = (properties = (Properties)context.getBean("spring.amqp.global.properties", Properties.class)).getProperty("mlc.possible.authentication.failure.fatal")))) {
                    this.setPossibleAuthenticationFailureFatal(Boolean.parseBoolean(possibleAuthenticationFailureFatalProperty));
                }
            }
            catch (BeansException be) {
                this.logger.debug((Object)"No global properties bean");
            }
        }
    }

    @Nullable
    protected List<Message> debatch(Message message) {
        if (this.isBatchListener && this.isDeBatchingEnabled() && this.getBatchingStrategy().canDebatch(message.getMessageProperties())) {
            ArrayList<Message> messageList = new ArrayList<Message>();
            this.getBatchingStrategy().deBatch(message, messageList::add);
            return messageList;
        }
        return null;
    }

    @FunctionalInterface
    private static interface ContainerDelegate {
        public void invokeListener(Channel var1, Object var2);
    }

    public static class DefaultExclusiveConsumerLogger
    implements ConditionalExceptionLogger {
        public void log(Log logger, String message, Throwable cause) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(message + ": " + cause));
            }
        }
    }

    @FunctionalInterface
    public static interface JavaLangErrorHandler {
        public void handle(Error var1);
    }

    protected static final class WrappedTransactionException
    extends RuntimeException {
        protected WrappedTransactionException(Throwable cause) {
            super(cause);
        }
    }

    public static class SharedConnectionNotInitializedException
    extends RuntimeException {
        protected SharedConnectionNotInitializedException(String msg) {
            super(msg);
        }
    }
}

