/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcParameterUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

public class JdbcBatchItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(JdbcBatchItemWriter.class);
    protected NamedParameterJdbcOperations namedParameterJdbcTemplate;
    protected ItemPreparedStatementSetter<T> itemPreparedStatementSetter;
    protected ItemSqlParameterSourceProvider<T> itemSqlParameterSourceProvider;
    protected String sql;
    protected boolean assertUpdates = true;
    protected int parameterCount;
    protected boolean usingNamedParameters;

    public void setAssertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setItemPreparedStatementSetter(ItemPreparedStatementSetter<T> preparedStatementSetter) {
        this.itemPreparedStatementSetter = preparedStatementSetter;
    }

    public void setItemSqlParameterSourceProvider(ItemSqlParameterSourceProvider<T> itemSqlParameterSourceProvider) {
        this.itemSqlParameterSourceProvider = itemSqlParameterSourceProvider;
    }

    public void setDataSource(DataSource dataSource) {
        if (this.namedParameterJdbcTemplate == null) {
            this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
        }
    }

    public void setJdbcTemplate(NamedParameterJdbcOperations namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public void afterPropertiesSet() {
        Assert.state((this.namedParameterJdbcTemplate != null ? 1 : 0) != 0, (String)"A DataSource or a NamedParameterJdbcTemplate is required.");
        Assert.state((this.sql != null ? 1 : 0) != 0, (String)"An SQL statement is required.");
        ArrayList<String> namedParameters = new ArrayList<String>();
        this.parameterCount = JdbcParameterUtils.countParameterPlaceholders(this.sql, namedParameters);
        if (namedParameters.size() > 0) {
            if (this.parameterCount != namedParameters.size()) {
                throw new InvalidDataAccessApiUsageException("You can't use both named parameters and classic \"?\" placeholders: " + this.sql);
            }
            this.usingNamedParameters = true;
        }
        if (!this.usingNamedParameters) {
            Assert.state((this.itemPreparedStatementSetter != null ? 1 : 0) != 0, (String)"Using SQL statement with '?' placeholders requires an ItemPreparedStatementSetter");
        }
    }

    @Override
    public void write(Chunk<? extends T> chunk) throws Exception {
        if (!chunk.isEmpty()) {
            int[] updateCounts;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing batch with " + chunk.size() + " items."));
            }
            if (this.usingNamedParameters) {
                if (chunk.getItems().get(0) instanceof Map && this.itemSqlParameterSourceProvider == null) {
                    updateCounts = this.namedParameterJdbcTemplate.batchUpdate(this.sql, chunk.getItems().toArray(new Map[chunk.size()]));
                } else {
                    SqlParameterSource[] batchArgs = new SqlParameterSource[chunk.size()];
                    int i = 0;
                    for (Object item : chunk) {
                        batchArgs[i++] = this.itemSqlParameterSourceProvider.createSqlParameterSource(item);
                    }
                    updateCounts = this.namedParameterJdbcTemplate.batchUpdate(this.sql, batchArgs);
                }
            } else {
                updateCounts = (int[])this.namedParameterJdbcTemplate.getJdbcOperations().execute(this.sql, ps -> {
                    for (Object item : chunk) {
                        this.itemPreparedStatementSetter.setValues(item, ps);
                        ps.addBatch();
                    }
                    return ps.executeBatch();
                });
            }
            if (this.assertUpdates) {
                for (int i = 0; i < updateCounts.length; ++i) {
                    int value = updateCounts[i];
                    if (value != 0) continue;
                    throw new EmptyResultDataAccessException("Item " + i + " of " + updateCounts.length + " did not update any rows: [" + String.valueOf(chunk.getItems().get(i)) + "]", 1);
                }
            }
            this.processUpdateCounts(updateCounts);
        }
    }

    protected void processUpdateCounts(int[] updateCounts) {
    }
}

