/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Order(value=2147483627)
class OnExpressionCondition
extends SpringBootCondition {
    OnExpressionCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        BeanExpressionContext expressionContext;
        String expression = (String)metadata.getAnnotationAttributes(ConditionalOnExpression.class.getName()).get("value");
        String rawExpression = expression = this.wrapIfNecessary(expression);
        expression = context.getEnvironment().resolvePlaceholders(expression);
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        BeanExpressionResolver resolver = beanFactory != null ? beanFactory.getBeanExpressionResolver() : null;
        BeanExpressionContext beanExpressionContext = expressionContext = beanFactory != null ? new BeanExpressionContext((ConfigurableBeanFactory)beanFactory, null) : null;
        if (resolver == null) {
            resolver = new StandardBeanExpressionResolver();
        }
        boolean result = (Boolean)resolver.evaluate(expression, expressionContext);
        return new ConditionOutcome(result, ConditionMessage.forCondition(ConditionalOnExpression.class, "(" + rawExpression + ")").resultedIn(result));
    }

    private String wrapIfNecessary(String expression) {
        if (!expression.startsWith("#{")) {
            return "#{" + expression + "}";
        }
        return expression;
    }
}

