/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.boot.devtools.restart.AgentReloader;
import org.springframework.boot.devtools.restart.DefaultRestartInitializer;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogMessage;

public class RestartApplicationListener
implements ApplicationListener<ApplicationEvent>,
Ordered {
    private static final String ENABLED_PROPERTY = "spring.devtools.restart.enabled";
    private static final Log logger = LogFactory.getLog(RestartApplicationListener.class);
    private int order = Integer.MIN_VALUE;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationStartingEvent) {
            this.onApplicationStartingEvent((ApplicationStartingEvent)event);
        }
        if (event instanceof ApplicationPreparedEvent) {
            this.onApplicationPreparedEvent((ApplicationPreparedEvent)event);
        }
        if (event instanceof ApplicationReadyEvent || event instanceof ApplicationFailedEvent) {
            Restarter.getInstance().finish();
        }
        if (event instanceof ApplicationFailedEvent) {
            this.onApplicationFailedEvent((ApplicationFailedEvent)event);
        }
    }

    private void onApplicationStartingEvent(ApplicationStartingEvent event) {
        String enabled = System.getProperty(ENABLED_PROPERTY);
        DefaultRestartInitializer restartInitializer = null;
        if (enabled == null) {
            restartInitializer = new DefaultRestartInitializer();
        } else if (Boolean.parseBoolean(enabled)) {
            restartInitializer = new DefaultRestartInitializer(){

                @Override
                protected boolean isDevelopmentClassLoader(ClassLoader classLoader) {
                    return true;
                }
            };
            logger.info((Object)LogMessage.format((String)"Restart enabled irrespective of application packaging due to System property '%s' being set to true", (Object)ENABLED_PROPERTY));
        }
        if (restartInitializer != null) {
            boolean restartOnInitialize;
            String[] args = event.getArgs();
            DefaultRestartInitializer initializer = new DefaultRestartInitializer();
            boolean bl = restartOnInitialize = !AgentReloader.isActive();
            if (!restartOnInitialize) {
                logger.info((Object)"Restart disabled due to an agent-based reloader being active");
            }
            Restarter.initialize(args, false, initializer, restartOnInitialize);
        } else {
            logger.info((Object)LogMessage.format((String)"Restart disabled due to System property '%s' being set to false", (Object)ENABLED_PROPERTY));
            Restarter.disable();
        }
    }

    private void onApplicationPreparedEvent(ApplicationPreparedEvent event) {
        Restarter.getInstance().prepare(event.getApplicationContext());
    }

    private void onApplicationFailedEvent(ApplicationFailedEvent event) {
        Restarter.getInstance().remove(event.getApplicationContext());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

