/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.classpath;

import java.util.Set;
import org.springframework.boot.devtools.filewatch.ChangedFile;
import org.springframework.boot.devtools.filewatch.ChangedFiles;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class ClassPathChangedEvent
extends ApplicationEvent {
    private final Set<ChangedFiles> changeSet;
    private final boolean restartRequired;

    public ClassPathChangedEvent(Object source, Set<ChangedFiles> changeSet, boolean restartRequired) {
        super(source);
        Assert.notNull(changeSet, (String)"ChangeSet must not be null");
        this.changeSet = changeSet;
        this.restartRequired = restartRequired;
    }

    public Set<ChangedFiles> getChangeSet() {
        return this.changeSet;
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("changeSet", this.changeSet).append("restartRequired", this.restartRequired).toString();
    }

    public String overview() {
        int added = 0;
        int deleted = 0;
        int modified = 0;
        for (ChangedFiles changedFiles : this.changeSet) {
            for (ChangedFile changedFile : changedFiles) {
                ChangedFile.Type type = changedFile.getType();
                if (type == ChangedFile.Type.ADD) {
                    ++added;
                    continue;
                }
                if (type == ChangedFile.Type.DELETE) {
                    ++deleted;
                    continue;
                }
                if (type != ChangedFile.Type.MODIFY) continue;
                ++modified;
            }
        }
        int size = added + deleted + modified;
        return String.format("%s (%s, %s, %s)", this.quantityOfUnit(size, "class path change"), this.quantityOfUnit(added, "addition"), this.quantityOfUnit(deleted, "deletion"), this.quantityOfUnit(modified, "modification"));
    }

    private String quantityOfUnit(int quantity, String unit) {
        return quantity + " " + (quantity != 1 ? unit + "s" : unit);
    }
}

