/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.net.http.HttpClient;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.AbstractClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.JdkHttpClientBuilder;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class JdkClientHttpRequestFactoryBuilder
extends AbstractClientHttpRequestFactoryBuilder<JdkClientHttpRequestFactory> {
    private final JdkHttpClientBuilder httpClientBuilder;

    JdkClientHttpRequestFactoryBuilder() {
        this(null, new JdkHttpClientBuilder());
    }

    private JdkClientHttpRequestFactoryBuilder(@Nullable List<Consumer<JdkClientHttpRequestFactory>> customizers, JdkHttpClientBuilder httpClientBuilder) {
        super(customizers);
        this.httpClientBuilder = httpClientBuilder;
    }

    public JdkClientHttpRequestFactoryBuilder withCustomizer(Consumer<JdkClientHttpRequestFactory> customizer) {
        return new JdkClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizer), this.httpClientBuilder);
    }

    public JdkClientHttpRequestFactoryBuilder withCustomizers(Collection<Consumer<JdkClientHttpRequestFactory>> customizers) {
        return new JdkClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizers), this.httpClientBuilder);
    }

    public JdkClientHttpRequestFactoryBuilder withExecutor(Executor executor) {
        return new JdkClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withExecutor(executor));
    }

    public JdkClientHttpRequestFactoryBuilder withHttpClientCustomizer(Consumer<HttpClient.Builder> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, (String)"'httpClientCustomizer' must not be null");
        return new JdkClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withCustomizer(httpClientCustomizer));
    }

    public JdkClientHttpRequestFactoryBuilder with(UnaryOperator<JdkClientHttpRequestFactoryBuilder> customizer) {
        return (JdkClientHttpRequestFactoryBuilder)customizer.apply(this);
    }

    @Override
    protected JdkClientHttpRequestFactory createClientHttpRequestFactory(HttpClientSettings settings) {
        HttpClient httpClient = this.httpClientBuilder.build(settings.withReadTimeout(null));
        JdkClientHttpRequestFactory requestFactory = new JdkClientHttpRequestFactory(httpClient);
        PropertyMapper map = PropertyMapper.get();
        map.from(settings::readTimeout).to(arg_0 -> ((JdkClientHttpRequestFactory)requestFactory).setReadTimeout(arg_0));
        return requestFactory;
    }

    static class Classes {
        static final String HTTP_CLIENT = "java.net.http.HttpClient";

        Classes() {
        }

        static boolean present(@Nullable ClassLoader classLoader) {
            return ClassUtils.isPresent((String)HTTP_CLIENT, (ClassLoader)classLoader);
        }
    }
}

