/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.jdbc.autoconfigure.JdbcTemplateAutoConfiguration;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.simple.JdbcClient;

@AutoConfiguration(after={JdbcTemplateAutoConfiguration.class})
@ConditionalOnSingleCandidate(value=NamedParameterJdbcTemplate.class)
@ConditionalOnMissingBean(value={JdbcClient.class})
@Import(value={DatabaseInitializationDependencyConfigurer.class})
public class JdbcClientAutoConfiguration {
    @Bean
    JdbcClient jdbcClient(NamedParameterJdbcTemplate jdbcTemplate) {
        return JdbcClient.create((NamedParameterJdbcOperations)jdbcTemplate);
    }
}

