/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.encrypt.EnvironmentDecryptApplicationInitializer;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.bootstrap.encrypt.RsaProperties;
import org.springframework.cloud.bootstrap.encrypt.TextEncryptorUtils;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={TextEncryptor.class})
@EnableConfigurationProperties
public class EncryptionBootstrapConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public KeyProperties keyProperties() {
        return new KeyProperties();
    }

    @Bean
    public EnvironmentDecryptApplicationInitializer environmentDecryptApplicationListener(ConfigurableApplicationContext context, KeyProperties keyProperties) {
        TextEncryptor encryptor;
        try {
            encryptor = (TextEncryptor)context.getBean(TextEncryptor.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            encryptor = new TextEncryptorUtils.FailsafeTextEncryptor();
        }
        EnvironmentDecryptApplicationInitializer listener = new EnvironmentDecryptApplicationInitializer(encryptor);
        listener.setFailOnError(keyProperties.isFailOnError());
        return listener;
    }

    @Deprecated
    public static TextEncryptor createTextEncryptor(KeyProperties keyProperties, RsaProperties rsaProperties) {
        return TextEncryptorUtils.createTextEncryptor(keyProperties, rsaProperties);
    }

    @Deprecated
    protected static class FailsafeTextEncryptor
    extends TextEncryptorUtils.FailsafeTextEncryptor {
        protected FailsafeTextEncryptor() {
        }
    }

    public static class KeyCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment = context.getEnvironment();
            if (this.hasProperty(environment, "encrypt.key-store.location")) {
                if (this.hasProperty(environment, "encrypt.key-store.password")) {
                    return ConditionOutcome.match((String)"Keystore found in Environment");
                }
                return ConditionOutcome.noMatch((String)"Keystore found but no password in Environment");
            }
            if (this.hasProperty(environment, "encrypt.key")) {
                return ConditionOutcome.match((String)"Key found in Environment");
            }
            return ConditionOutcome.noMatch((String)"Keystore nor key found in Environment");
        }

        private boolean hasProperty(Environment environment, String key) {
            String value = environment.getProperty(key);
            if (value == null) {
                return false;
            }
            return StringUtils.hasText((String)environment.resolvePlaceholders(value));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={KeyCondition.class})
    @ConditionalOnMissingClass(value={"org.springframework.security.rsa.crypto.RsaSecretEncryptor"})
    protected static class VanillaEncryptionConfiguration {
        @Autowired
        private KeyProperties key;

        protected VanillaEncryptionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={TextEncryptor.class})
        public TextEncryptor textEncryptor() {
            return new EncryptorFactory(this.key.getSalt()).create(this.key.getKey());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={KeyCondition.class})
    @ConditionalOnClass(value={RsaSecretEncryptor.class})
    @EnableConfigurationProperties
    protected static class RsaEncryptionConfiguration {
        protected RsaEncryptionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RsaProperties rsaProperties() {
            return new RsaProperties();
        }

        @Bean
        @ConditionalOnMissingBean(value={TextEncryptor.class})
        public TextEncryptor textEncryptor(KeyProperties keyProperties, RsaProperties rsaProperties) {
            return TextEncryptorUtils.createTextEncryptor(keyProperties, rsaProperties);
        }
    }
}

