/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server.event;

import com.netflix.appinfo.InstanceInfo;
import java.util.Objects;
import org.springframework.context.ApplicationEvent;

public class EurekaInstanceRegisteredEvent
extends ApplicationEvent {
    private InstanceInfo instanceInfo;
    private int leaseDuration;
    private boolean replication;

    public EurekaInstanceRegisteredEvent(Object source, InstanceInfo instanceInfo, int leaseDuration, boolean replication) {
        super(source);
        this.instanceInfo = instanceInfo;
        this.leaseDuration = leaseDuration;
        this.replication = replication;
    }

    public InstanceInfo getInstanceInfo() {
        return this.instanceInfo;
    }

    public void setInstanceInfo(InstanceInfo instanceInfo) {
        this.instanceInfo = instanceInfo;
    }

    public int getLeaseDuration() {
        return this.leaseDuration;
    }

    public void setLeaseDuration(int leaseDuration) {
        this.leaseDuration = leaseDuration;
    }

    public boolean isReplication() {
        return this.replication;
    }

    public void setReplication(boolean replication) {
        this.replication = replication;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EurekaInstanceRegisteredEvent that = (EurekaInstanceRegisteredEvent)((Object)o);
        return Objects.equals(this.instanceInfo, that.instanceInfo) && this.leaseDuration == this.leaseDuration && this.replication == this.replication;
    }

    public int hashCode() {
        return Objects.hash(this.instanceInfo, this.leaseDuration, this.replication);
    }

    public String toString() {
        return "EurekaInstanceRegisteredEvent{" + "instanceInfo=" + this.instanceInfo + ", " + "leaseDuration=" + this.leaseDuration + ", " + "replication=" + this.replication + "}";
    }
}

