/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.loadbalancer.Server;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public final class RibbonUtils {
    public static final String VALUE_NOT_SET = "__not__set__";
    public static final String DEFAULT_NAMESPACE = "ribbon";
    private static final Map<String, String> unsecureSchemeMapping = new HashMap<String, String>();

    private RibbonUtils() {
        throw new AssertionError((Object)"Must not instantiate utility class.");
    }

    public static void initializeRibbonDefaults(String serviceId) {
        RibbonUtils.setRibbonProperty(serviceId, CommonClientConfigKey.DeploymentContextBasedVipAddresses.key(), serviceId);
        RibbonUtils.setRibbonProperty(serviceId, CommonClientConfigKey.EnableZoneAffinity.key(), "true");
    }

    public static void setRibbonProperty(String serviceId, String suffix, String value) {
        String key = RibbonUtils.getRibbonKey(serviceId, suffix);
        DynamicStringProperty property = RibbonUtils.getProperty(key);
        if (property.get().equals(VALUE_NOT_SET)) {
            ConfigurationManager.getConfigInstance().setProperty(key, (Object)value);
        }
    }

    public static String getRibbonKey(String serviceId, String suffix) {
        return serviceId + "." + DEFAULT_NAMESPACE + "." + suffix;
    }

    public static DynamicStringProperty getProperty(String key) {
        return DynamicPropertyFactory.getInstance().getStringProperty(key, VALUE_NOT_SET);
    }

    public static boolean isSecure(IClientConfig config, ServerIntrospector serverIntrospector, Server server) {
        Boolean isSecure;
        if (config != null && (isSecure = (Boolean)config.get(CommonClientConfigKey.IsSecure)) != null) {
            return isSecure;
        }
        return serverIntrospector.isSecure(server);
    }

    public static URI updateToHttpsIfNeeded(URI uri, IClientConfig config, ServerIntrospector serverIntrospector, Server server) {
        return RibbonUtils.updateToSecureConnectionIfNeeded(uri, config, serverIntrospector, server);
    }

    static URI updateToSecureConnectionIfNeeded(URI uri, ServiceInstance ribbonServer) {
        String scheme = uri.getScheme();
        if (StringUtils.isEmpty((Object)scheme)) {
            scheme = "http";
        }
        if (!StringUtils.isEmpty((Object)uri.toString()) && unsecureSchemeMapping.containsKey(scheme) && ribbonServer.isSecure()) {
            return RibbonUtils.upgradeConnection(uri, unsecureSchemeMapping.get(scheme));
        }
        return uri;
    }

    public static URI updateToSecureConnectionIfNeeded(URI uri, IClientConfig config, ServerIntrospector serverIntrospector, Server server) {
        String scheme = uri.getScheme();
        if (StringUtils.isEmpty((Object)scheme)) {
            scheme = "http";
        }
        if (!StringUtils.isEmpty((Object)uri.toString()) && unsecureSchemeMapping.containsKey(scheme) && RibbonUtils.isSecure(config, serverIntrospector, server)) {
            return RibbonUtils.upgradeConnection(uri, unsecureSchemeMapping.get(scheme));
        }
        return uri;
    }

    private static URI upgradeConnection(URI uri, String scheme) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri((URI)uri).scheme(scheme);
        if (uri.getRawQuery() != null) {
            uriComponentsBuilder.replaceQuery(uri.getRawQuery().replace("+", "%20"));
        }
        return uriComponentsBuilder.build(true).toUri();
    }

    static {
        unsecureSchemeMapping.put("http", "https");
        unsecureSchemeMapping.put("ws", "wss");
    }
}

