/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.annotation.ContinueSpan;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.SpanTag;
import org.springframework.cloud.sleuth.instrument.annotation.SleuthAnnotatedParameter;
import org.springframework.core.annotation.AnnotationUtils;

final class SleuthAnnotationUtils {
    private static final Log log = LogFactory.getLog(SleuthAnnotationUtils.class);

    private SleuthAnnotationUtils() {
    }

    static boolean isMethodAnnotated(Method method) {
        return SleuthAnnotationUtils.findAnnotation(method, NewSpan.class) != null || SleuthAnnotationUtils.findAnnotation(method, ContinueSpan.class) != null;
    }

    static boolean hasAnnotatedParams(Method method, Object[] args) {
        return !SleuthAnnotationUtils.findAnnotatedParameters(method, args).isEmpty();
    }

    static List<SleuthAnnotatedParameter> findAnnotatedParameters(Method method, Object[] args) {
        Annotation[][] parameters = method.getParameterAnnotations();
        ArrayList<SleuthAnnotatedParameter> result = new ArrayList<SleuthAnnotatedParameter>();
        int i = 0;
        Annotation[][] annotationArray = parameters;
        int n = annotationArray.length;
        for (int j = 0; j < n; ++j) {
            Annotation[] parameter;
            for (Annotation parameter2 : parameter = annotationArray[j]) {
                if (!(parameter2 instanceof SpanTag)) continue;
                result.add(new SleuthAnnotatedParameter(i, (SpanTag)parameter2, args[i]));
            }
            ++i;
        }
        return result;
    }

    static <T extends Annotation> T findAnnotation(Method method, Class<T> clazz) {
        Annotation annotation;
        block3: {
            annotation = AnnotationUtils.findAnnotation((Method)method, clazz);
            if (annotation == null) {
                try {
                    annotation = AnnotationUtils.findAnnotation((Method)method.getDeclaringClass().getMethod(method.getName(), method.getParameterTypes()), clazz);
                }
                catch (NoSuchMethodException | SecurityException ex) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Exception occurred while tyring to find the annotation", (Throwable)ex);
                }
            }
        }
        return (T)annotation;
    }
}

