/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.reflect.Method;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class StreamAnnotationCommonMethodUtils {
    public static String getOutboundBindingTargetName(Method method) {
        SendTo sendTo = (SendTo)AnnotationUtils.findAnnotation((Method)method, SendTo.class);
        if (sendTo != null) {
            Assert.isTrue((!ObjectUtils.isEmpty((Object[])sendTo.value()) ? 1 : 0) != 0, (String)"At least one output must be specified");
            Assert.isTrue((sendTo.value().length == 1 ? 1 : 0) != 0, (String)"Multiple destinations cannot be specified");
            Assert.hasText((String)sendTo.value()[0], (String)"An empty destination cannot be specified");
            return sendTo.value()[0];
        }
        Output output = (Output)AnnotationUtils.findAnnotation((Method)method, Output.class);
        if (output != null) {
            Assert.isTrue((boolean)StringUtils.hasText((String)output.value()), (String)"At least one output must be specified");
            return output.value();
        }
        return null;
    }

    public static int outputAnnotationCount(Method method) {
        int outputAnnotationCount = 0;
        for (int parameterIndex = 0; parameterIndex < method.getParameterTypes().length; ++parameterIndex) {
            MethodParameter methodParameter = MethodParameter.forMethodOrConstructor((Object)method, (int)parameterIndex);
            if (!methodParameter.hasParameterAnnotation(Output.class)) continue;
            ++outputAnnotationCount;
        }
        return outputAnnotationCount;
    }
}

