/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.lang.NonNull;

public abstract class Jsr310TimestampBasedConverters {
    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList(8);
        converters.add(TimestampToLocalDateTimeConverter.INSTANCE);
        converters.add(TimestampToLocalDateConverter.INSTANCE);
        converters.add(LocalDateToTimestampConverter.INSTANCE);
        converters.add(TimestampToLocalTimeConverter.INSTANCE);
        converters.add(LocalTimeToTimestampConverter.INSTANCE);
        converters.add(TimestampToInstantConverter.INSTANCE);
        converters.add(InstantToTimestampConverter.INSTANCE);
        return converters;
    }

    @WritingConverter
    public static enum InstantToTimestampConverter implements Converter<Instant, Timestamp>
    {
        INSTANCE;


        @NonNull
        public Timestamp convert(Instant source) {
            return Timestamp.from(source);
        }
    }

    @ReadingConverter
    public static enum TimestampToInstantConverter implements Converter<Timestamp, Instant>
    {
        INSTANCE;


        @NonNull
        public Instant convert(Timestamp source) {
            return source.toInstant();
        }
    }

    @WritingConverter
    public static enum LocalTimeToTimestampConverter implements Converter<LocalTime, Timestamp>
    {
        INSTANCE;


        @NonNull
        public Timestamp convert(LocalTime source) {
            return Timestamp.from(source.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    @ReadingConverter
    public static enum TimestampToLocalTimeConverter implements Converter<Timestamp, LocalTime>
    {
        INSTANCE;


        @NonNull
        public LocalTime convert(Timestamp source) {
            return source.toLocalDateTime().toLocalTime();
        }
    }

    @WritingConverter
    public static enum LocalDateToTimestampConverter implements Converter<LocalDate, Timestamp>
    {
        INSTANCE;


        @NonNull
        public Timestamp convert(LocalDate source) {
            return Timestamp.from(source.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
    }

    @ReadingConverter
    public static enum TimestampToLocalDateConverter implements Converter<Timestamp, LocalDate>
    {
        INSTANCE;


        @NonNull
        public LocalDate convert(Timestamp source) {
            return source.toLocalDateTime().toLocalDate();
        }
    }

    @WritingConverter
    public static enum LocalDateTimeToTimestampConverter implements Converter<LocalDateTime, Timestamp>
    {
        INSTANCE;


        @NonNull
        public Timestamp convert(LocalDateTime source) {
            return Timestamp.from(source.atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    @ReadingConverter
    public static enum TimestampToLocalDateTimeConverter implements Converter<Timestamp, LocalDateTime>
    {
        INSTANCE;


        @NonNull
        public LocalDateTime convert(Timestamp source) {
            return LocalDateTime.ofInstant(source.toInstant(), ZoneId.systemDefault());
        }
    }
}

