/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;

class SqlContext {
    private final RelationalPersistentEntity<?> entity;
    private final Table table;

    SqlContext(RelationalPersistentEntity<?> entity) {
        this.entity = entity;
        this.table = Table.create((SqlIdentifier)entity.getTableName());
    }

    Column getIdColumn() {
        return this.table.column(this.entity.getIdColumn());
    }

    Column getVersionColumn() {
        return this.table.column(((RelationalPersistentProperty)this.entity.getRequiredVersionProperty()).getColumnName());
    }

    Table getTable() {
        return this.table;
    }

    Table getTable(PersistentPropertyPathExtension path) {
        SqlIdentifier tableAlias = path.getTableAlias();
        Table table = Table.create((SqlIdentifier)path.getTableName());
        return tableAlias == null ? table : table.as(tableAlias);
    }

    Column getColumn(PersistentPropertyPathExtension path) {
        return this.getTable(path).column(path.getColumnName()).as(path.getColumnAlias());
    }

    Column getReverseColumn(PersistentPropertyPathExtension path) {
        return this.getTable(path).column(path.getReverseColumnName()).as(path.getReverseColumnNameAlias());
    }
}

