/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.dialect;

import java.sql.Array;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.postgresql.jdbc.TypeInfoCache;
import org.springframework.data.jdbc.core.dialect.JdbcArrayColumns;
import org.springframework.data.jdbc.core.dialect.JdbcDialect;
import org.springframework.data.relational.core.dialect.PostgresDialect;
import org.springframework.util.ClassUtils;

public class JdbcPostgresDialect
extends PostgresDialect
implements JdbcDialect {
    public static final JdbcPostgresDialect INSTANCE = new JdbcPostgresDialect();
    private static final JdbcPostgresArrayColumns ARRAY_COLUMNS = new JdbcPostgresArrayColumns();
    private static final Set<Class<?>> SIMPLE_TYPES;

    public Set<Class<?>> simpleTypes() {
        return SIMPLE_TYPES;
    }

    @Override
    public JdbcArrayColumns getArraySupport() {
        return ARRAY_COLUMNS;
    }

    private static void ifClassPresent(String className, Consumer<Class<?>> action) {
        if (ClassUtils.isPresent((String)className, (ClassLoader)PostgresDialect.class.getClassLoader())) {
            action.accept(ClassUtils.resolveClassName((String)className, (ClassLoader)PostgresDialect.class.getClassLoader()));
        }
    }

    static {
        HashSet simpleTypes = new HashSet(PostgresDialect.INSTANCE.simpleTypes());
        List<String> simpleTypeNames = Arrays.asList("org.postgresql.util.PGobject", "org.postgresql.geometric.PGpoint", "org.postgresql.geometric.PGbox", "org.postgresql.geometric.PGcircle", "org.postgresql.geometric.PGline", "org.postgresql.geometric.PGpath", "org.postgresql.geometric.PGpolygon", "org.postgresql.geometric.PGlseg");
        simpleTypeNames.forEach(name -> JdbcPostgresDialect.ifClassPresent(name, simpleTypes::add));
        SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
    }

    static class JdbcPostgresArrayColumns
    implements JdbcArrayColumns {
        private static final boolean TYPE_INFO_PRESENT = ClassUtils.isPresent((String)"org.postgresql.jdbc.TypeInfoCache", (ClassLoader)JdbcPostgresDialect.class.getClassLoader());
        private static final TypeInfoWrapper TYPE_INFO_WRAPPER = TYPE_INFO_PRESENT ? new TypeInfoCacheWrapper() : new TypeInfoWrapper();

        JdbcPostgresArrayColumns() {
        }

        public boolean isSupported() {
            return true;
        }

        @Override
        public SQLType getSqlType(Class<?> componentType) {
            SQLType sqlType = TYPE_INFO_WRAPPER.getArrayTypeMap().get(componentType);
            if (sqlType != null) {
                return sqlType;
            }
            return JdbcArrayColumns.super.getSqlType(componentType);
        }

        @Override
        public String getArrayTypeName(SQLType jdbcType) {
            if (jdbcType == JDBCType.DOUBLE) {
                return "FLOAT8";
            }
            if (jdbcType == JDBCType.REAL) {
                return "FLOAT4";
            }
            return jdbcType.getName();
        }
    }

    static class TypeInfoCacheWrapper
    extends TypeInfoWrapper {
        private final Map<Class<?>, SQLType> arrayTypes = new HashMap();

        public TypeInfoCacheWrapper() {
            TypeInfoCache cache = new TypeInfoCache(null, 0);
            TypeInfoCacheWrapper.addWellKnownTypes(cache);
            Iterator it = cache.getPGTypeNamesWithSQLTypes();
            try {
                while (it.hasNext()) {
                    Class javaClass;
                    String pgTypeName = (String)it.next();
                    int oid = cache.getPGType(pgTypeName);
                    String javaClassName = cache.getJavaClass(oid);
                    int arrayOid = cache.getJavaArrayType(pgTypeName);
                    if (!ClassUtils.isPresent((String)javaClassName, (ClassLoader)this.getClass().getClassLoader()) || (javaClass = ClassUtils.forName((String)javaClassName, (ClassLoader)this.getClass().getClassLoader())) == Array.class || javaClass == String.class || javaClass == Integer.class || oid == 26 || oid == 790) continue;
                    this.arrayTypes.put(javaClass, new PGSQLType(pgTypeName, arrayOid));
                }
            }
            catch (ClassNotFoundException | SQLException e) {
                throw new IllegalStateException("Cannot create type info mapping", e);
            }
        }

        private static void addWellKnownTypes(TypeInfoCache cache) {
            cache.addCoreType("uuid", Integer.valueOf(2950), Integer.valueOf(1111), UUID.class.getName(), Integer.valueOf(2951));
        }

        @Override
        Map<Class<?>, SQLType> getArrayTypeMap() {
            return this.arrayTypes;
        }

        record PGSQLType(String name, int oid) implements SQLType
        {
            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getVendor() {
                return "Postgres";
            }

            @Override
            public Integer getVendorTypeNumber() {
                return this.oid;
            }
        }
    }

    static class TypeInfoWrapper {
        TypeInfoWrapper() {
        }

        Map<Class<?>, SQLType> getArrayTypeMap() {
            return Collections.emptyMap();
        }
    }
}

