/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.PartTreeJdbcQuery;
import org.springframework.data.jdbc.repository.query.RowMapperFactory;
import org.springframework.data.jdbc.repository.query.StringBasedJdbcQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.repository.support.RelationalQueryLookupStrategy;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.util.Assert;

abstract class JdbcQueryLookupStrategy
extends RelationalQueryLookupStrategy {
    private static final Log LOG = LogFactory.getLog(JdbcQueryLookupStrategy.class);
    final JdbcAggregateOperations operations;
    final RowMapperFactory rowMapperFactory;
    final ValueExpressionDelegate delegate;

    JdbcQueryLookupStrategy(JdbcAggregateOperations operations, RowMapperFactory rowMapperFactory, ValueExpressionDelegate delegate) {
        super((MappingContext)operations.getConverter().getMappingContext(), operations.getDataAccessStrategy().getDialect());
        Assert.notNull((Object)rowMapperFactory, (String)"RowMapperFactory must not be null");
        Assert.notNull((Object)delegate, (String)"ValueExpressionDelegate must not be null");
        this.rowMapperFactory = rowMapperFactory;
        this.operations = operations;
        this.delegate = delegate;
    }

    JdbcQueryMethod getJdbcQueryMethod(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        return new JdbcQueryMethod(method, repositoryMetadata, projectionFactory, namedQueries, this.getMappingContext());
    }

    public static QueryLookupStrategy create(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable QueryLookupStrategy.Key key, JdbcAggregateOperations operations, RowMapperFactory rowMapperFactory, ValueExpressionDelegate delegate) {
        Assert.notNull((Object)operations, (String)"JdbcAggregateOperations must not be null");
        Assert.notNull((Object)rowMapperFactory, (String)"RowMapperFactory must not be null");
        Assert.notNull((Object)delegate, (String)"ValueExpressionDelegate must not be null");
        CreateQueryLookupStrategy createQueryLookupStrategy = new CreateQueryLookupStrategy(operations, rowMapperFactory, delegate);
        DeclaredQueryLookupStrategy declaredQueryLookupStrategy = new DeclaredQueryLookupStrategy(operations, rowMapperFactory, delegate);
        QueryLookupStrategy.Key keyToUse = key != null ? key : QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND;
        LOG.debug((Object)String.format("Using the queryLookupStrategy %s", keyToUse));
        return switch (keyToUse) {
            default -> throw new IncompatibleClassChangeError();
            case QueryLookupStrategy.Key.CREATE -> createQueryLookupStrategy;
            case QueryLookupStrategy.Key.USE_DECLARED_QUERY -> declaredQueryLookupStrategy;
            case QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND -> new CreateIfNotFoundQueryLookupStrategy(operations, rowMapperFactory, createQueryLookupStrategy, declaredQueryLookupStrategy, delegate);
        };
    }

    static class CreateQueryLookupStrategy
    extends JdbcQueryLookupStrategy {
        CreateQueryLookupStrategy(JdbcAggregateOperations operations, RowMapperFactory rowMapperFactory, ValueExpressionDelegate delegate) {
            super(operations, rowMapperFactory, delegate);
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            JdbcQueryMethod queryMethod = this.getJdbcQueryMethod(method, repositoryMetadata, projectionFactory, namedQueries);
            return new PartTreeJdbcQuery(queryMethod, this.operations, this.rowMapperFactory);
        }
    }

    static class DeclaredQueryLookupStrategy
    extends JdbcQueryLookupStrategy {
        DeclaredQueryLookupStrategy(JdbcAggregateOperations operations, RowMapperFactory rowMapperFactory, ValueExpressionDelegate delegate) {
            super(operations, rowMapperFactory, delegate);
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            JdbcQueryMethod queryMethod = this.getJdbcQueryMethod(method, repositoryMetadata, projectionFactory, namedQueries);
            if (namedQueries.hasQuery(queryMethod.getNamedQueryName()) || queryMethod.hasAnnotatedQuery()) {
                if (queryMethod.hasAnnotatedQuery() && queryMethod.hasAnnotatedQueryName()) {
                    LOG.warn((Object)String.format("Query method %s is annotated with both, a query and a query name; Using the declared query", method));
                }
                String queryString = this.evaluateTableExpressions(repositoryMetadata, queryMethod.getRequiredQuery());
                return new StringBasedJdbcQuery(queryString, queryMethod, this.operations, this.rowMapperFactory, this.delegate);
            }
            throw new IllegalStateException(String.format("Did neither find a NamedQuery nor an annotated query for method %s", method));
        }
    }

    static class CreateIfNotFoundQueryLookupStrategy
    extends JdbcQueryLookupStrategy {
        private final DeclaredQueryLookupStrategy lookupStrategy;
        private final CreateQueryLookupStrategy createStrategy;

        CreateIfNotFoundQueryLookupStrategy(JdbcAggregateOperations operations, RowMapperFactory rowMapperFactory, CreateQueryLookupStrategy createStrategy, DeclaredQueryLookupStrategy lookupStrategy, ValueExpressionDelegate delegate) {
            super(operations, rowMapperFactory, delegate);
            Assert.notNull((Object)((Object)createStrategy), (String)"CreateQueryLookupStrategy must not be null");
            Assert.notNull((Object)((Object)lookupStrategy), (String)"DeclaredQueryLookupStrategy must not be null");
            this.createStrategy = createStrategy;
            this.lookupStrategy = lookupStrategy;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            try {
                return this.lookupStrategy.resolveQuery(method, repositoryMetadata, projectionFactory, namedQueries);
            }
            catch (IllegalStateException e) {
                return this.createStrategy.resolveQuery(method, repositoryMetadata, projectionFactory, namedQueries);
            }
        }
    }
}

