/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.support.FetchableFluentQueryByExample;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.repository.query.RelationalExampleMapper;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.repository.query.QueryByExampleExecutor;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public class SimpleJdbcRepository<T, ID>
implements CrudRepository<T, ID>,
PagingAndSortingRepository<T, ID>,
QueryByExampleExecutor<T> {
    private final SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
    private final JdbcAggregateOperations entityOperations;
    private final PersistentEntity<T, ?> entity;
    private final RelationalExampleMapper exampleMapper;

    public SimpleJdbcRepository(JdbcAggregateOperations entityOperations, PersistentEntity<T, ?> entity, JdbcConverter converter) {
        Assert.notNull((Object)entityOperations, (String)"EntityOperations must not be null");
        Assert.notNull(entity, (String)"Entity must not be null");
        this.entityOperations = entityOperations;
        this.entity = entity;
        this.exampleMapper = new RelationalExampleMapper((MappingContext)converter.getMappingContext());
    }

    @Transactional
    public <S extends T> S save(S instance) {
        return this.entityOperations.save(instance);
    }

    @Transactional
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        return this.entityOperations.saveAll(entities);
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.entityOperations.findById(id, this.entity.getType()));
    }

    public boolean existsById(ID id) {
        return this.entityOperations.existsById(id, this.entity.getType());
    }

    public List<T> findAll() {
        return this.entityOperations.findAll(this.entity.getType());
    }

    public List<T> findAllById(Iterable<ID> ids) {
        return this.entityOperations.findAllById(ids, this.entity.getType());
    }

    public long count() {
        return this.entityOperations.count(this.entity.getType());
    }

    @Transactional
    public void deleteById(ID id) {
        this.entityOperations.deleteById(id, this.entity.getType());
    }

    @Transactional
    public void delete(T instance) {
        this.entityOperations.delete(instance);
    }

    @Transactional
    public void deleteAllById(Iterable<? extends ID> ids) {
        this.entityOperations.deleteAllById(ids, this.entity.getType());
    }

    @Transactional
    public void deleteAll(Iterable<? extends T> entities) {
        this.entityOperations.deleteAll(entities);
    }

    @Transactional
    public void deleteAll() {
        this.entityOperations.deleteAll(this.entity.getType());
    }

    public List<T> findAll(Sort sort) {
        return this.entityOperations.findAll(this.entity.getType(), sort);
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        Query query = Query.query((CriteriaDefinition)CriteriaDefinition.empty()).with(pageable);
        List content = this.entityOperations.findAll(query, this.entity.getType());
        return PageableExecutionUtils.getPage(content, (Pageable)pageable, () -> this.entityOperations.count(this.entity.getType()));
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        Assert.notNull(example, (String)"Example must not be null");
        return this.entityOperations.findOne(this.exampleMapper.getMappedExample(example), example.getProbeType());
    }

    public <S extends T> List<S> findAll(Example<S> example) {
        Assert.notNull(example, (String)"Example must not be null");
        return this.findAll((Example)example, Sort.unsorted());
    }

    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        Assert.notNull(example, (String)"Example must not be null");
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        return this.entityOperations.findAll(this.exampleMapper.getMappedExample(example).sort(sort), example.getProbeType());
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        Assert.notNull(example, (String)"Example must not be null");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        Query mappedQuery = this.exampleMapper.getMappedExample(example);
        List content = this.entityOperations.findAll(mappedQuery.with(pageable), example.getProbeType());
        return PageableExecutionUtils.getPage(content, (Pageable)pageable, () -> this.entityOperations.count(mappedQuery, example.getProbeType()));
    }

    public <S extends T> long count(Example<S> example) {
        Assert.notNull(example, (String)"Example must not be null");
        return this.entityOperations.count(this.exampleMapper.getMappedExample(example), example.getProbeType());
    }

    public <S extends T> boolean exists(Example<S> example) {
        Assert.notNull(example, (String)"Example must not be null");
        return this.entityOperations.exists(this.exampleMapper.getMappedExample(example), example.getProbeType());
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(example, (String)"Sample must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        FetchableFluentQueryByExample fluentQuery = new FetchableFluentQueryByExample(example, example.getProbeType(), this.exampleMapper, this.entityOperations, (ProjectionFactory)this.projectionFactory);
        return queryFunction.apply(fluentQuery);
    }
}

