/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.LockModeType;
import javax.persistence.QueryHint;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.query.DefaultJpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributeSource;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributes;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JpaQueryMethod
extends QueryMethod {
    private static final Set<Class<?>> NATIVE_ARRAY_TYPES;
    private static final StoredProcedureAttributeSource storedProcedureAttributeSource;
    private final QueryExtractor extractor;
    private final Method method;
    private StoredProcedureAttributes storedProcedureAttributes;

    public JpaQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, QueryExtractor extractor) {
        super(method, metadata, factory);
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull((Object)extractor, (String)"Query extractor must not be null!");
        this.method = method;
        this.extractor = extractor;
        Assert.isTrue((!this.isModifyingQuery() || !this.getParameters().hasSpecialParameter() ? 1 : 0) != 0, (String)String.format("Modifying method must not contain %s!", Parameters.TYPES));
        this.assertParameterNamesInAnnotatedQuery();
    }

    private void assertParameterNamesInAnnotatedQuery() {
        String annotatedQuery = this.getAnnotatedQuery();
        if (!QueryUtils.hasNamedParameter(annotatedQuery)) {
            return;
        }
        Iterator iterator = this.getParameters().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (!parameter.isNamedParameter() || annotatedQuery.contains(String.format(":%s", parameter.getName())) || annotatedQuery.contains(String.format("#%s", parameter.getName()))) continue;
            throw new IllegalStateException(String.format("Using named parameters for method %s but parameter '%s' not found in annotated query '%s'!", this.method, parameter.getName(), annotatedQuery));
        }
    }

    public JpaEntityMetadata<?> getEntityInformation() {
        return new DefaultJpaEntityMetadata(this.getDomainClass());
    }

    public boolean isModifyingQuery() {
        return null != AnnotationUtils.findAnnotation((Method)this.method, Modifying.class);
    }

    List<QueryHint> getHints() {
        ArrayList<QueryHint> result = new ArrayList<QueryHint>();
        QueryHints hints = (QueryHints)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, QueryHints.class);
        if (hints != null) {
            result.addAll(Arrays.asList(hints.value()));
        }
        return result;
    }

    LockModeType getLockModeType() {
        Lock annotation = (Lock)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Lock.class);
        return (LockModeType)AnnotationUtils.getValue((Annotation)annotation);
    }

    JpaEntityGraph getEntityGraph() {
        EntityGraph annotation = (EntityGraph)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, EntityGraph.class);
        return annotation == null ? null : new JpaEntityGraph(annotation, this.getNamedQueryName());
    }

    boolean applyHintsToCountQuery() {
        QueryHints hints = (QueryHints)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, QueryHints.class);
        return hints != null ? hints.forCounting() : false;
    }

    QueryExtractor getQueryExtractor() {
        return this.extractor;
    }

    Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    String getAnnotatedQuery() {
        String query = this.getAnnotationValue("value", String.class);
        return StringUtils.hasText((String)query) ? query : null;
    }

    String getCountQuery() {
        String countQuery = this.getAnnotationValue("countQuery", String.class);
        return StringUtils.hasText((String)countQuery) ? countQuery : null;
    }

    String getCountQueryProjection() {
        String countProjection = this.getAnnotationValue("countProjection", String.class);
        return StringUtils.hasText((String)countProjection) ? countProjection : null;
    }

    boolean isNativeQuery() {
        return this.getAnnotationValue("nativeQuery", Boolean.class);
    }

    public String getNamedQueryName() {
        String annotatedName = this.getAnnotationValue("name", String.class);
        return StringUtils.hasText((String)annotatedName) ? annotatedName : super.getNamedQueryName();
    }

    String getNamedCountQueryName() {
        String annotatedName = this.getAnnotationValue("countName", String.class);
        return StringUtils.hasText((String)annotatedName) ? annotatedName : this.getNamedQueryName() + ".count";
    }

    boolean getFlushAutomatically() {
        return this.getMergedOrDefaultAnnotationValue("flushAutomatically", Modifying.class, Boolean.class);
    }

    boolean getClearAutomatically() {
        return this.getMergedOrDefaultAnnotationValue("clearAutomatically", Modifying.class, Boolean.class);
    }

    private <T> T getAnnotationValue(String attribute, Class<T> type) {
        return this.getMergedOrDefaultAnnotationValue(attribute, Query.class, type);
    }

    private <T> T getMergedOrDefaultAnnotationValue(String attribute, Class annotationType, Class<T> targetType) {
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, (Class)annotationType);
        if (annotation == null) {
            return targetType.cast(AnnotationUtils.getDefaultValue((Class)annotationType, (String)attribute));
        }
        return targetType.cast(AnnotationUtils.getValue((Annotation)annotation, (String)attribute));
    }

    protected JpaParameters createParameters(Method method) {
        return new JpaParameters(method);
    }

    public JpaParameters getParameters() {
        return (JpaParameters)super.getParameters();
    }

    public boolean isCollectionQuery() {
        return super.isCollectionQuery() && !NATIVE_ARRAY_TYPES.contains(this.method.getReturnType());
    }

    public boolean isProcedureQuery() {
        return AnnotationUtils.findAnnotation((Method)this.method, Procedure.class) != null;
    }

    StoredProcedureAttributes getProcedureAttributes() {
        if (this.storedProcedureAttributes == null) {
            this.storedProcedureAttributes = storedProcedureAttributeSource.createFrom(this.method, (JpaEntityMetadata<?>)this.getEntityInformation());
        }
        return this.storedProcedureAttributes;
    }

    static {
        storedProcedureAttributeSource = StoredProcedureAttributeSource.INSTANCE;
        HashSet<Class> types = new HashSet<Class>();
        types.add(byte[].class);
        types.add(Byte[].class);
        types.add(char[].class);
        types.add(Character[].class);
        NATIVE_ARRAY_TYPES = Collections.unmodifiableSet(types);
    }
}

