/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.OperationType;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.Document;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class ChangeStreamEvent<T> {
    private static final AtomicReferenceFieldUpdater<ChangeStreamEvent, Object> CONVERTED_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ChangeStreamEvent.class, Object.class, "converted");
    @Nullable
    private final ChangeStreamDocument<Document> raw;
    private final Class<T> targetType;
    private final MongoConverter converter;
    @Nullable
    private volatile T converted;

    public ChangeStreamEvent(@Nullable ChangeStreamDocument<Document> raw, Class<T> targetType, MongoConverter converter) {
        this.raw = raw;
        this.targetType = targetType;
        this.converter = converter;
    }

    @Nullable
    public ChangeStreamDocument<Document> getRaw() {
        return this.raw;
    }

    @Nullable
    public Instant getTimestamp() {
        return this.getBsonTimestamp() != null ? (Instant)this.converter.getConversionService().convert((Object)this.raw.getClusterTime(), Instant.class) : null;
    }

    @Nullable
    public BsonTimestamp getBsonTimestamp() {
        return this.raw != null ? this.raw.getClusterTime() : null;
    }

    @Nullable
    public BsonValue getResumeToken() {
        return this.raw != null ? this.raw.getResumeToken() : null;
    }

    @Nullable
    public OperationType getOperationType() {
        return this.raw != null ? this.raw.getOperationType() : null;
    }

    @Nullable
    public String getDatabaseName() {
        return this.raw != null ? this.raw.getNamespace().getDatabaseName() : null;
    }

    @Nullable
    public String getCollectionName() {
        return this.raw != null ? this.raw.getNamespace().getCollectionName() : null;
    }

    @Nullable
    public T getBody() {
        if (this.raw == null) {
            return null;
        }
        Document fullDocument = (Document)this.raw.getFullDocument();
        if (fullDocument == null) {
            return this.targetType.cast(fullDocument);
        }
        return this.getConverted(fullDocument);
    }

    private T getConverted(Document fullDocument) {
        return (T)this.doGetConverted(fullDocument);
    }

    private Object doGetConverted(Document fullDocument) {
        Object result = CONVERTED_UPDATER.get(this);
        if (result != null) {
            return result;
        }
        if (ClassUtils.isAssignable(Document.class, fullDocument.getClass())) {
            result = this.converter.read(this.targetType, fullDocument);
            return CONVERTED_UPDATER.compareAndSet(this, null, result) ? result : CONVERTED_UPDATER.get(this);
        }
        if (this.converter.getConversionService().canConvert(fullDocument.getClass(), this.targetType)) {
            result = this.converter.getConversionService().convert((Object)fullDocument, this.targetType);
            return CONVERTED_UPDATER.compareAndSet(this, null, result) ? result : CONVERTED_UPDATER.get(this);
        }
        throw new IllegalArgumentException(String.format("No converter found capable of converting %s to %s", fullDocument.getClass(), this.targetType));
    }

    public String toString() {
        return "ChangeStreamEvent {raw=" + this.raw + ", targetType=" + this.targetType + '}';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeStreamEvent)) {
            return false;
        }
        ChangeStreamEvent other = (ChangeStreamEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChangeStreamDocument<Document> this$raw = this.getRaw();
        ChangeStreamDocument<Document> other$raw = other.getRaw();
        if (this$raw == null ? other$raw != null : !this$raw.equals(other$raw)) {
            return false;
        }
        Class<T> this$targetType = this.targetType;
        Class<T> other$targetType = other.targetType;
        if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
            return false;
        }
        MongoConverter this$converter = this.converter;
        MongoConverter other$converter = other.converter;
        if (this$converter == null ? other$converter != null : !this$converter.equals(other$converter)) {
            return false;
        }
        T this$converted = this.converted;
        T other$converted = other.converted;
        return !(this$converted == null ? other$converted != null : !this$converted.equals(other$converted));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangeStreamEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChangeStreamDocument<Document> $raw = this.getRaw();
        result = result * 59 + ($raw == null ? 43 : $raw.hashCode());
        Class<T> $targetType = this.targetType;
        result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
        MongoConverter $converter = this.converter;
        result = result * 59 + ($converter == null ? 43 : $converter.hashCode());
        T $converted = this.converted;
        result = result * 59 + ($converted == null ? 43 : $converted.hashCode());
        return result;
    }
}

