/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.DocumentReference;
import org.springframework.data.mongodb.core.mapping.Encrypted;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.FieldType;
import org.springframework.data.mongodb.core.mapping.Language;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.TextScore;
import org.springframework.data.mongodb.util.encryption.EncryptionUtils;
import org.springframework.data.util.Lazy;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BasicMongoPersistentProperty
extends AnnotationBasedPersistentProperty<MongoPersistentProperty>
implements MongoPersistentProperty {
    private static final Log LOG = LogFactory.getLog(BasicMongoPersistentProperty.class);
    public static final String ID_FIELD_NAME = "_id";
    private static final String LANGUAGE_FIELD_NAME = "language";
    private static final Set<Class<?>> SUPPORTED_ID_TYPES = new HashSet();
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = new HashSet<String>();
    private final FieldNamingStrategy fieldNamingStrategy;

    public BasicMongoPersistentProperty(Property property, MongoPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder, @Nullable FieldNamingStrategy fieldNamingStrategy) {
        super(property, owner, simpleTypeHolder);
        String annotatedName;
        Object object = this.fieldNamingStrategy = fieldNamingStrategy == null ? PropertyNameFieldNamingStrategy.INSTANCE : fieldNamingStrategy;
        if (this.isIdProperty() && this.hasExplicitFieldName() && !ID_FIELD_NAME.equals(annotatedName = this.getAnnotatedFieldName()) && LOG.isWarnEnabled()) {
            LOG.warn((Object)String.format("Customizing field name for id property '%s.%s' is not allowed; Custom name ('%s') will not be considered", owner.getName(), this.getName(), annotatedName));
        }
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        return SUPPORTED_ID_PROPERTY_NAMES.contains(this.getName()) && !this.hasExplicitFieldName();
    }

    @Override
    public boolean isExplicitIdProperty() {
        return super.isIdProperty();
    }

    @Override
    public String getFieldName() {
        if (this.isIdProperty()) {
            if (this.getOwner().getIdProperty() == null) {
                return ID_FIELD_NAME;
            }
            if (this.getOwner().isIdProperty((PersistentProperty)this)) {
                return ID_FIELD_NAME;
            }
        }
        if (this.hasExplicitFieldName()) {
            return this.getAnnotatedFieldName();
        }
        String fieldName = this.fieldNamingStrategy.getFieldName((PersistentProperty)this);
        if (!StringUtils.hasText((String)fieldName)) {
            throw new MappingException(String.format("Invalid (null or empty) field name returned for property %s by %s", this, this.fieldNamingStrategy.getClass()));
        }
        return fieldName;
    }

    @Override
    public Class<?> getFieldType() {
        Field fieldAnnotation = (Field)this.findAnnotation(Field.class);
        if (!this.isIdProperty()) {
            if (fieldAnnotation == null || fieldAnnotation.targetType() == FieldType.IMPLICIT) {
                return this.getType();
            }
            return fieldAnnotation.targetType().getJavaClass();
        }
        if (fieldAnnotation == null) {
            return FieldType.OBJECT_ID.getJavaClass();
        }
        FieldType fieldType = fieldAnnotation.targetType();
        if (fieldType == FieldType.IMPLICIT) {
            if (this.isEntity()) {
                return Document.class;
            }
            return this.getType();
        }
        return fieldType.getJavaClass();
    }

    @Override
    public boolean hasExplicitFieldName() {
        return StringUtils.hasText((String)this.getAnnotatedFieldName());
    }

    @Nullable
    private String getAnnotatedFieldName() {
        Field annotation = (Field)this.findAnnotation(Field.class);
        return annotation != null ? annotation.value() : null;
    }

    @Override
    public int getFieldOrder() {
        Field annotation = (Field)this.findAnnotation(Field.class);
        return annotation != null ? annotation.order() : Integer.MAX_VALUE;
    }

    @Override
    public boolean writeNullValues() {
        Field annotation = (Field)this.findAnnotation(Field.class);
        return annotation != null && annotation.write() == Field.Write.ALWAYS;
    }

    protected Association<MongoPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public boolean isDbReference() {
        return this.isAnnotationPresent(DBRef.class);
    }

    @Override
    public boolean isDocumentReference() {
        return this.isAnnotationPresent(DocumentReference.class);
    }

    @Override
    @Nullable
    public DBRef getDBRef() {
        return (DBRef)this.findAnnotation(DBRef.class);
    }

    @Override
    @Nullable
    public DocumentReference getDocumentReference() {
        return (DocumentReference)this.findAnnotation(DocumentReference.class);
    }

    @Override
    public boolean isLanguageProperty() {
        return this.getFieldName().equals(LANGUAGE_FIELD_NAME) || this.isExplicitLanguageProperty();
    }

    @Override
    public boolean isExplicitLanguageProperty() {
        return this.isAnnotationPresent(Language.class);
    }

    @Override
    public boolean isTextScoreProperty() {
        return this.isAnnotationPresent(TextScore.class);
    }

    public EvaluationContext getEvaluationContext(@Nullable Object rootObject) {
        if (this.getOwner() instanceof BasicMongoPersistentEntity) {
            return ((BasicMongoPersistentEntity)this.getOwner()).getEvaluationContext(rootObject);
        }
        return rootObject != null ? new StandardEvaluationContext(rootObject) : new StandardEvaluationContext();
    }

    @Override
    public Collection<Object> getEncryptionKeyIds() {
        Encrypted encrypted = (Encrypted)this.findAnnotation(Encrypted.class);
        if (encrypted == null) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object[])encrypted.keyId())) {
            return Collections.emptySet();
        }
        Lazy evaluationContext = Lazy.of(() -> {
            EvaluationContext ctx = this.getEvaluationContext(null);
            ctx.setVariable("target", (Object)(this.getOwner().getType().getSimpleName() + "." + this.getName()));
            return ctx;
        });
        ArrayList<Object> target = new ArrayList<Object>();
        for (String keyId : encrypted.keyId()) {
            target.add(EncryptionUtils.resolveKeyId(keyId, (Supplier<EvaluationContext>)evaluationContext));
        }
        return target;
    }

    static {
        SUPPORTED_ID_TYPES.add(ObjectId.class);
        SUPPORTED_ID_TYPES.add(String.class);
        SUPPORTED_ID_TYPES.add(BigInteger.class);
        SUPPORTED_ID_PROPERTY_NAMES.add("id");
        SUPPORTED_ID_PROPERTY_NAMES.add(ID_FIELD_NAME);
    }
}

