/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.client.result.UpdateResult;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.DtoInstantiatingConverter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.Point;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.ReactiveUpdateOperation;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.ReactiveWrappers;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

interface ReactiveMongoQueryExecution {
    public Publisher<? extends Object> execute(Query var1, Class<?> var2, String var3);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        private final ResultProcessor processor;
        private final ReactiveMongoOperations operations;
        private final EntityInstantiators instantiators;

        public ResultProcessingConverter(ResultProcessor processor, ReactiveMongoOperations operations, EntityInstantiators instantiators) {
            Assert.notNull((Object)processor, (String)"Processor must not be null");
            Assert.notNull((Object)operations, (String)"Operations must not be null");
            Assert.notNull((Object)instantiators, (String)"Instantiators must not be null");
            this.processor = processor;
            this.operations = operations;
            this.instantiators = instantiators;
        }

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ReflectionUtils.isVoid((Class)returnedType.getReturnedType())) {
                if (source instanceof Mono) {
                    return ((Mono)source).then();
                }
                if (source instanceof Publisher) {
                    return Flux.from((Publisher)((Publisher)source)).then();
                }
            }
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            if (!this.operations.getConverter().getMappingContext().hasPersistentEntityFor(returnedType.getReturnedType())) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.operations.getConverter().getMappingContext(), this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }
    }

    public static final class ResultProcessingExecution
    implements ReactiveMongoQueryExecution {
        private final ReactiveMongoQueryExecution delegate;
        private final Converter<Object, Object> converter;

        public ResultProcessingExecution(ReactiveMongoQueryExecution delegate, Converter<Object, Object> converter) {
            Assert.notNull((Object)delegate, (String)"Delegate must not be null");
            Assert.notNull(converter, (String)"Converter must not be null");
            this.delegate = delegate;
            this.converter = converter;
        }

        @Override
        public Publisher<? extends Object> execute(Query query, Class<?> type, String collection) {
            return (Publisher)this.converter.convert(this.delegate.execute(query, type, collection));
        }
    }

    public static final class UpdateExecution
    implements ReactiveMongoQueryExecution {
        private final ReactiveUpdateOperation.ReactiveUpdate<?> updateOps;
        private final MongoQueryMethod method;
        private final MongoParameterAccessor accessor;
        private Mono<UpdateDefinition> update;

        UpdateExecution(ReactiveUpdateOperation.ReactiveUpdate<?> updateOps, ReactiveMongoQueryMethod method, MongoParameterAccessor accessor, Mono<UpdateDefinition> update) {
            this.updateOps = updateOps;
            this.method = method;
            this.accessor = accessor;
            this.update = update;
        }

        @Override
        public Publisher<? extends Object> execute(Query query, Class<?> type, String collection) {
            return this.update.flatMap(it -> this.updateOps.inCollection(collection).matching(query.with(this.accessor.getSort())).apply((UpdateDefinition)it).all().map(UpdateResult::getModifiedCount));
        }
    }

    public static final class DeleteExecution
    implements ReactiveMongoQueryExecution {
        private final ReactiveMongoOperations operations;
        private final MongoQueryMethod method;

        public DeleteExecution(ReactiveMongoOperations operations, MongoQueryMethod method) {
            this.operations = operations;
            this.method = method;
        }

        @Override
        public Publisher<? extends Object> execute(Query query, Class<?> type, String collection) {
            if (this.method.isCollectionQuery()) {
                return this.operations.findAllAndRemove(query, type, collection);
            }
            if (this.method.isQueryForEntity() && !ClassUtils.isPrimitiveOrWrapper((Class)this.method.getReturnedObjectType())) {
                return this.operations.findAndRemove(query, type, collection);
            }
            return this.operations.remove(query, type, collection).map(deleteResult -> deleteResult.wasAcknowledged() ? deleteResult.getDeletedCount() : 0L);
        }
    }

    public static class GeoNearExecution
    implements ReactiveMongoQueryExecution {
        private final ReactiveMongoOperations operations;
        private final MongoParameterAccessor accessor;
        private final TypeInformation<?> returnType;

        public GeoNearExecution(ReactiveMongoOperations operations, MongoParameterAccessor accessor, TypeInformation<?> returnType) {
            this.operations = operations;
            this.accessor = accessor;
            this.returnType = returnType;
        }

        @Override
        public Publisher<? extends Object> execute(Query query, Class<?> type, String collection) {
            Flux results = this.doExecuteQuery(query, type, collection);
            return this.isStreamOfGeoResult() ? results : results.map(GeoResult::getContent);
        }

        protected Flux<GeoResult<Object>> doExecuteQuery(@Nullable Query query, Class<?> type, String collection) {
            Point nearLocation = this.accessor.getGeoNearLocation();
            NearQuery nearQuery = NearQuery.near(nearLocation);
            if (query != null) {
                nearQuery.query(query);
            }
            Range<Distance> distances = this.accessor.getDistanceRange();
            distances.getUpperBound().getValue().ifPresent(it -> nearQuery.maxDistance((Distance)it).in(it.getMetric()));
            distances.getLowerBound().getValue().ifPresent(it -> nearQuery.minDistance((Distance)it).in(it.getMetric()));
            Pageable pageable = this.accessor.getPageable();
            nearQuery.with(pageable);
            return this.operations.geoNear(nearQuery, type, collection);
        }

        private boolean isStreamOfGeoResult() {
            if (!ReactiveWrappers.supports((Class)this.returnType.getType())) {
                return false;
            }
            TypeInformation componentType = this.returnType.getComponentType();
            return componentType != null && GeoResult.class.equals((Object)componentType.getType());
        }
    }
}

