/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.List;
import org.bson.Document;
import org.reactivestreams.Publisher;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractReactiveMongoQuery;
import org.springframework.data.mongodb.repository.query.AggregationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryExecution;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.expression.ExpressionParser;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveStringBasedAggregation
extends AbstractReactiveMongoQuery {
    private final ReactiveMongoOperations reactiveMongoOperations;
    private final MongoConverter mongoConverter;

    @Deprecated(since="4.4.0")
    public ReactiveStringBasedAggregation(ReactiveMongoQueryMethod method, ReactiveMongoOperations reactiveMongoOperations, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, reactiveMongoOperations, expressionParser, evaluationContextProvider);
        this.reactiveMongoOperations = reactiveMongoOperations;
        this.mongoConverter = reactiveMongoOperations.getConverter();
    }

    public ReactiveStringBasedAggregation(ReactiveMongoQueryMethod method, ReactiveMongoOperations reactiveMongoOperations, ValueExpressionDelegate delegate) {
        super(method, reactiveMongoOperations, delegate);
        this.reactiveMongoOperations = reactiveMongoOperations;
        this.mongoConverter = reactiveMongoOperations.getConverter();
    }

    @Override
    protected Publisher<Object> doExecute(ReactiveMongoQueryMethod method, ResultProcessor processor, ConvertingParameterAccessor accessor, @Nullable Class<?> ignored) {
        return this.computePipeline(accessor).flatMapMany(it -> (Publisher)AggregationUtils.doAggregate(new AggregationPipeline((List<AggregationOperation>)it), method, processor, accessor, this::getValueExpressionEvaluator, (aggregation, sourceType, typeToRead, elementType, simpleType, rawResult) -> {
            Flux flux = this.reactiveMongoOperations.aggregate(aggregation, typeToRead);
            if (ReflectionUtils.isVoid((Class)elementType)) {
                return flux.then();
            }
            ReactiveMongoQueryExecution.ResultProcessingConverter resultProcessing = this.getResultProcessing(processor);
            if (simpleType && !rawResult && !elementType.equals(Document.class)) {
                flux = flux.handle((item, sink) -> {
                    Object result = AggregationUtils.extractSimpleTypeResult((Document)item, elementType, this.mongoConverter);
                    if (result != null) {
                        sink.next(result);
                    }
                });
            }
            flux = flux.map(resultProcessing::convert);
            return method.isCollectionQuery() ? flux : flux.next();
        }));
    }

    private boolean isSimpleReturnType(Class<?> targetType) {
        return MongoSimpleTypes.HOLDER.isSimpleType(targetType);
    }

    private Mono<List<AggregationOperation>> computePipeline(ConvertingParameterAccessor accessor) {
        return this.parseAggregationPipeline(this.getQueryMethod().getAnnotatedAggregation(), accessor);
    }

    @Override
    protected Mono<Query> createQuery(ConvertingParameterAccessor accessor) {
        throw new UnsupportedOperationException("No query support for aggregation");
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }
}

