/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.json;

import java.util.Collections;
import java.util.Map;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.util.json.ValueProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;

class EvaluationContextExpressionEvaluator
implements ValueExpressionEvaluator {
    final ValueProvider valueProvider;
    final ExpressionParser expressionParser;

    EvaluationContextExpressionEvaluator(ValueProvider valueProvider, ExpressionParser expressionParser) {
        this.valueProvider = valueProvider;
        this.expressionParser = expressionParser;
    }

    @Nullable
    public <T> T evaluate(String expression) {
        return this.evaluateExpression(expression, Collections.emptyMap());
    }

    EvaluationContext getEvaluationContext(String expressionString) {
        return new StandardEvaluationContext();
    }

    Expression getParsedExpression(String expressionString) {
        return this.expressionParser.parseExpression(expressionString);
    }

    <T> T evaluateExpression(String expressionString, Map<String, Object> variables) {
        Expression expression = this.getParsedExpression(expressionString);
        EvaluationContext ctx = this.getEvaluationContext(expressionString);
        variables.forEach((arg_0, arg_1) -> ((EvaluationContext)ctx).setVariable(arg_0, arg_1));
        Object result = expression.getValue(ctx, Object.class);
        return (T)result;
    }
}

