/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import lombok.NonNull;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisScriptReturnConverter;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.JedisCluster;

class JedisClusterScriptingCommands
implements RedisScriptingCommands {
    @NonNull
    private final JedisClusterConnection connection;

    @Override
    public void scriptFlush() {
        try {
            this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(BinaryJedis::scriptFlush);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void scriptKill() {
        try {
            this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(BinaryJedis::scriptKill);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public String scriptLoad(byte[] script) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        try {
            ClusterCommandExecutor.MultiNodeResult<byte[]> multiNodeResult = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(client -> client.scriptLoad(script));
            return JedisConverters.toString(multiNodeResult.getFirstNonNullNotEmptyOrDefault(new byte[0]));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptShas) {
        throw new InvalidDataAccessApiUsageException("ScriptExists is not supported in cluster environment.");
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        try {
            return (T)new JedisScriptReturnConverter(returnType).convert(this.getCluster().eval(script, JedisConverters.toBytes(numKeys), keysAndArgs));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public <T> T evalSha(String scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return this.evalSha(JedisConverters.toBytes(scriptSha), returnType, numKeys, keysAndArgs);
    }

    @Override
    public <T> T evalSha(byte[] scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)scriptSha, (String)"Script digest must not be null!");
        try {
            return (T)new JedisScriptReturnConverter(returnType).convert(this.getCluster().evalsha(scriptSha, numKeys, keysAndArgs));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    protected RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }

    private JedisCluster getCluster() {
        return this.connection.getCluster();
    }

    public JedisClusterScriptingCommands(@NonNull JedisClusterConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        this.connection = connection;
    }
}

