/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.dsl;

import java.util.Properties;
import java.util.function.Consumer;
import javax.activation.FileTypeMap;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.mail.MailSendingMessageHandler;
import org.springframework.integration.support.PropertiesBuilder;
import org.springframework.lang.Nullable;
import org.springframework.mail.MailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class MailSendingMessageHandlerSpec
extends MessageHandlerSpec<MailSendingMessageHandlerSpec, MailSendingMessageHandler> {
    private final JavaMailSenderImpl sender = new JavaMailSenderImpl();

    MailSendingMessageHandlerSpec(@Nullable String host) {
        this.sender.setHost(host);
        this.target = new MailSendingMessageHandler((MailSender)this.sender);
    }

    public MailSendingMessageHandlerSpec javaMailProperties(Properties javaMailProperties) {
        this.sender.setJavaMailProperties(javaMailProperties);
        return this;
    }

    public MailSendingMessageHandlerSpec javaMailProperties(Consumer<PropertiesBuilder> propertiesConfigurer) {
        PropertiesBuilder properties = new PropertiesBuilder();
        propertiesConfigurer.accept(properties);
        return this.javaMailProperties(properties.get());
    }

    public MailSendingMessageHandlerSpec protocol(@Nullable String protocol) {
        this.sender.setProtocol(protocol);
        return this;
    }

    public MailSendingMessageHandlerSpec port(int port) {
        this.sender.setPort(port);
        return this;
    }

    public MailSendingMessageHandlerSpec credentials(@Nullable String username, @Nullable String password) {
        this.sender.setUsername(username);
        this.sender.setPassword(password);
        return this;
    }

    public MailSendingMessageHandlerSpec password(@Nullable String password) {
        this.sender.setPassword(password);
        return this;
    }

    public MailSendingMessageHandlerSpec defaultEncoding(@Nullable String defaultEncoding) {
        this.sender.setDefaultEncoding(defaultEncoding);
        return this;
    }

    public MailSendingMessageHandlerSpec defaultFileTypeMap(@Nullable FileTypeMap defaultFileTypeMap) {
        this.sender.setDefaultFileTypeMap(defaultFileTypeMap);
        return this;
    }
}

