/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.SingleResultAuthorizationManager;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

final class PermitAllSupport {
    private PermitAllSupport() {
    }

    static void permitAll(HttpSecurityBuilder<? extends HttpSecurityBuilder<?>> http, String ... urls) {
        for (String url : urls) {
            if (url == null) continue;
            PermitAllSupport.permitAll(http, new ExactUrlRequestMatcher(url));
        }
    }

    static void permitAll(HttpSecurityBuilder<? extends HttpSecurityBuilder<?>> http, RequestMatcher ... requestMatchers) {
        AuthorizeHttpRequestsConfigurer httpConfigurer = http.getConfigurer(AuthorizeHttpRequestsConfigurer.class);
        Assert.state((httpConfigurer != null ? 1 : 0) != 0, (String)"permitAll only works with HttpSecurity.authorizeHttpRequests(). Please define one.");
        for (RequestMatcher matcher : requestMatchers) {
            if (matcher == null) continue;
            httpConfigurer.addFirst(matcher, (AuthorizationManager<RequestAuthorizationContext>)SingleResultAuthorizationManager.permitAll());
        }
    }

    private static final class ExactUrlRequestMatcher
    implements RequestMatcher {
        private String processUrl;

        private ExactUrlRequestMatcher(String processUrl) {
            this.processUrl = processUrl;
        }

        public boolean matches(HttpServletRequest request) {
            Object uri = request.getRequestURI();
            String query = request.getQueryString();
            if (query != null) {
                uri = (String)uri + "?" + query;
            }
            if ("".equals(request.getContextPath())) {
                return ((String)uri).equals(this.processUrl);
            }
            return ((String)uri).equals(request.getContextPath() + this.processUrl);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ExactUrl [processUrl='").append(this.processUrl).append("']");
            return sb.toString();
        }
    }
}

