/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import org.springframework.lang.Contract;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public abstract class AssertionErrors {
    @Contract(value="_ -> fail")
    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static void fail(String message, @Nullable Object expected, @Nullable Object actual) {
        throw new AssertionError((Object)(message + " expected:<" + String.valueOf(expected) + "> but was:<" + String.valueOf(actual) + ">"));
    }

    @Contract(value="_, false -> fail")
    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            AssertionErrors.fail(message);
        }
    }

    @Contract(value="_, true -> fail")
    public static void assertFalse(String message, boolean condition) {
        if (condition) {
            AssertionErrors.fail(message);
        }
    }

    @Contract(value="_, !null -> fail")
    public static void assertNull(String message, @Nullable Object object) {
        AssertionErrors.assertTrue(message, object == null);
    }

    @Contract(value="_, null -> fail")
    public static void assertNotNull(String message, @Nullable Object object) {
        AssertionErrors.assertTrue(message, object != null);
    }

    public static void assertEquals(String message, @Nullable Object expected, @Nullable Object actual) {
        if (!ObjectUtils.nullSafeEquals((Object)expected, (Object)actual)) {
            AssertionErrors.fail(message, ObjectUtils.nullSafeToString((Object)expected), ObjectUtils.nullSafeToString((Object)actual));
        }
    }

    public static void assertNotEquals(String message, @Nullable Object expected, @Nullable Object actual) {
        if (ObjectUtils.nullSafeEquals((Object)expected, (Object)actual)) {
            throw new AssertionError((Object)(message + " was not expected to be:<" + ObjectUtils.nullSafeToString((Object)actual) + ">"));
        }
    }
}

