/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.uml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.UMLPackage;
import org.springframework.statemachine.config.model.AbstractStateMachineModelFactory;
import org.springframework.statemachine.config.model.DefaultStateMachineModel;
import org.springframework.statemachine.config.model.StateMachineComponentResolver;
import org.springframework.statemachine.config.model.StateMachineModel;
import org.springframework.statemachine.config.model.StateMachineModelFactory;
import org.springframework.statemachine.uml.support.UmlModelParser;
import org.springframework.statemachine.uml.support.UmlUtils;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class UmlStateMachineModelFactory
extends AbstractStateMachineModelFactory<String, String>
implements StateMachineModelFactory<String, String> {
    private org.springframework.core.io.Resource resource;
    private String location;

    public UmlStateMachineModelFactory(org.springframework.core.io.Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must be set");
        this.resource = resource;
    }

    public UmlStateMachineModelFactory(String location) {
        Assert.notNull((Object)location, (String)"Location must be set");
        this.location = location;
    }

    public StateMachineModel<String, String> build() {
        Model model = null;
        Holder holder = null;
        Resource resource = null;
        try {
            holder = this.getResourceUri(this.resolveResource());
            resource = UmlUtils.getResource(holder.uri.getPath());
            model = (Model)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.MODEL);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot build build model from resource " + resource + " or location " + this.location, e);
        }
        finally {
            if (holder != null && holder.path != null) {
                try {
                    Files.deleteIfExists(holder.path);
                }
                catch (Exception exception) {}
            }
        }
        UmlModelParser parser = new UmlModelParser(model, (StateMachineComponentResolver<String, String>)this);
        UmlModelParser.DataHolder dataHolder = parser.parseModel();
        if (resource != null) {
            try {
                resource.unload();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (holder != null && holder.path != null) {
            try {
                Files.deleteIfExists(holder.path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DefaultStateMachineModel(null, dataHolder.getStatesData(), dataHolder.getTransitionsData());
    }

    private org.springframework.core.io.Resource resolveResource() {
        if (this.resource != null) {
            return this.resource;
        }
        return this.getResourceLoader().getResource(this.location);
    }

    private Holder getResourceUri(org.springframework.core.io.Resource resource) throws IOException {
        try {
            return new Holder(resource.getFile().toURI());
        }
        catch (Exception exception) {
            Path tempFile = Files.createTempFile(null, ".uml", new FileAttribute[0]);
            FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(tempFile.toFile()));
            return new Holder(tempFile.toUri(), tempFile);
        }
    }

    private static class Holder {
        URI uri;
        Path path;

        public Holder(URI uri) {
            this(uri, null);
        }

        public Holder(URI uri, Path path) {
            this.uri = uri;
            this.path = path;
        }
    }
}

