/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoUtils {
    private static final Logger logger = LoggerFactory.getLogger(IoUtils.class);
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("^(?!\\.)[\\u4e00-\\u9fa5_a-zA-Z0-9.\\-()]+$");

    public static boolean validateFileName(String name) {
        return FILE_NAME_PATTERN.matcher(name).matches();
    }

    public static List<File> files(File file, String suffix) {
        ArrayList<File> list = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] files = file.listFiles(path -> path.isDirectory() || path.getName().endsWith(suffix));
            if (files != null) {
                for (int i = files.length - 1; i >= 0; --i) {
                    list.addAll(IoUtils.files(files[i], suffix));
                }
            }
        } else if (file.exists()) {
            list.add(file);
        }
        return list;
    }

    public static List<File> dirs(File file) {
        return IoUtils.subDirs(true, file);
    }

    private static List<File> subDirs(boolean isRoot, File file) {
        ArrayList<File> list = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] files = file.listFiles(File::isDirectory);
            if (files != null) {
                for (int i = files.length - 1; i >= 0; --i) {
                    list.addAll(IoUtils.subDirs(false, files[i]));
                }
            }
            if (!isRoot) {
                list.add(file);
            }
        }
        return list;
    }

    public static byte[] bytes(File file) {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return new byte[0];
        }
    }

    public static String string(File file) {
        return new String(IoUtils.bytes(file), StandardCharsets.UTF_8);
    }

    public static byte[] bytes(InputStream inputStream) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((len = inputStream.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, len);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6InputStream\u5931\u8d25", (Throwable)e);
            return new byte[0];
        }
    }

    public static String string(InputStream inputStream) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            StringBuilder result = new StringBuilder();
            boolean flag = false;
            while ((line = reader.readLine()) != null) {
                if (flag) {
                    result.append("\r\n");
                }
                result.append(line);
                flag = true;
            }
            string = result.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("\u8bfb\u53d6InputStream\u5931\u8d25", (Throwable)e);
                return "";
            }
        }
        reader.close();
        return string;
    }

    public static boolean write(File file, byte[] bytes) {
        try {
            Files.write(file.toPath(), bytes, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            logger.error("\u5199\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static boolean write(File file, String content) {
        if (content == null) {
            return false;
        }
        return IoUtils.write(file, content.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean delete(File file) {
        File[] files;
        if (file == null) {
            return true;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (int i = files.length - 1; i >= 0; --i) {
                if (IoUtils.delete(files[i])) continue;
                return false;
            }
        }
        if (!file.exists()) {
            return true;
        }
        return file.delete();
    }

    public static void closeDataSource(DataSource dataSource) {
        if (dataSource != null) {
            if (dataSource instanceof Closeable) {
                try {
                    ((Closeable)((Object)dataSource)).close();
                }
                catch (Exception e) {
                    logger.warn("Close DataSource error", (Throwable)e);
                }
            } else {
                logger.warn("DataSource can not close");
            }
        }
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

