/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.utils;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.ssssssss.magicapi.utils.PathUtils;
import org.ssssssss.script.reflection.JavaReflection;

public class Mapping {
    private final AbstractHandlerMethodMapping<RequestMappingInfo> methodMapping;
    private final String base;
    private final RequestMappingInfo.BuilderConfiguration config;
    private static final boolean HAS_GET_PATTERN_PARSER = JavaReflection.getMethod(RequestMappingHandlerMapping.class, (String)"getPatternParser", (Object[])new Object[0]) != null;

    private Mapping(AbstractHandlerMethodMapping<RequestMappingInfo> methodMapping, RequestMappingInfo.BuilderConfiguration config, String base) {
        this.methodMapping = methodMapping;
        this.config = config;
        this.base = (String)StringUtils.defaultIfBlank((CharSequence)base, (CharSequence)"");
    }

    public static Mapping create(RequestMappingHandlerMapping mapping) {
        return Mapping.create(mapping, null);
    }

    public static Mapping create(RequestMappingHandlerMapping mapping, String base) {
        if (HAS_GET_PATTERN_PARSER) {
            RequestMappingInfo.BuilderConfiguration config = new RequestMappingInfo.BuilderConfiguration();
            config.setTrailingSlashMatch(mapping.useTrailingSlashMatch());
            config.setContentNegotiationManager(mapping.getContentNegotiationManager());
            if (mapping.getPatternParser() != null) {
                config.setPatternParser(mapping.getPatternParser());
            } else {
                config.setPathMatcher(mapping.getPathMatcher());
            }
            return new Mapping((AbstractHandlerMethodMapping<RequestMappingInfo>)mapping, config, base);
        }
        return new Mapping((AbstractHandlerMethodMapping<RequestMappingInfo>)mapping, null, base);
    }

    public RequestMappingInfo.Builder paths(String ... paths) {
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths((String[])paths);
        if (this.config != null) {
            return builder.options(this.config);
        }
        return builder;
    }

    public Mapping register(RequestMappingInfo requestMappingInfo, Object handler, Method method) {
        this.methodMapping.registerMapping((Object)requestMappingInfo, handler, method);
        return this;
    }

    public RequestMappingInfo register(String requestMethod, String path, Object handler, Method method) {
        RequestMappingInfo info = this.paths(path).methods(new RequestMethod[]{RequestMethod.valueOf((String)requestMethod.toUpperCase())}).build();
        this.register(info, handler, method);
        return info;
    }

    public Map<RequestMappingInfo, HandlerMethod> getHandlerMethods() {
        return this.methodMapping.getHandlerMethods();
    }

    public Mapping unregister(RequestMappingInfo info) {
        this.methodMapping.unregisterMapping((Object)info);
        return this;
    }

    public Mapping registerController(Object target) {
        Method[] methods;
        for (Method method : methods = target.getClass().getDeclaredMethods()) {
            RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
            if (requestMapping == null) continue;
            String[] paths = (String[])Stream.of(requestMapping.value()).map(value -> PathUtils.replaceSlash(this.base + value)).toArray(String[]::new);
            this.register(this.paths(paths).methods(requestMapping.method()).build(), target, method);
        }
        return this;
    }
}

