/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.compile;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.ssssssss.script.MagicScript;

public class CompileCache {
    private final LinkedHashMap<String, MagicScript> cacheMap;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public CompileCache(final int capacity) {
        this.cacheMap = new LinkedHashMap<String, MagicScript>((int)Math.ceil((double)capacity / 0.75) + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, MagicScript> eldest) {
                return this.size() > capacity;
            }
        };
    }

    public void put(String key, MagicScript script) {
        this.lock.writeLock().lock();
        try {
            this.cacheMap.put(key, script);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public MagicScript get(String key) {
        this.lock.readLock().lock();
        try {
            MagicScript magicScript = this.cacheMap.get(key);
            return magicScript;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MagicScript get(String key, Supplier<MagicScript> value) {
        MagicScript script = this.get(key);
        if (script == null) {
            script = value.get();
            this.put(key, script);
        }
        return script;
    }
}

