/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.literal;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.CharacterStream;
import org.ssssssss.script.parsing.Token;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Literal;
import org.ssssssss.script.parsing.ast.Node;

public class StringLiteral
extends Literal {
    private final Token token;
    private final List<Expression> expressionList;

    public StringLiteral(Token token) {
        this(token, null);
    }

    public StringLiteral(Token token, List<Expression> expressionList) {
        super(token.getSpan());
        this.token = token;
        this.expressionList = expressionList;
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        if (this.expressionList != null) {
            this.expressionList.forEach(expr -> expr.visitMethod(compiler));
        }
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        if (this.isTemplateString()) {
            if (this.expressionList.isEmpty()) {
                compiler.ldc("");
            } else {
                compiler.typeInsn(187, StringJoiner.class).insn(89).ldc("").invoke(183, StringJoiner.class, "<init>", Void.TYPE, CharSequence.class);
                this.expressionList.forEach(expression -> compiler.visit((Node)expression).ldc("").invoke(184, Objects.class, "toString", String.class, Object.class, String.class).invoke(182, StringJoiner.class, "add", StringJoiner.class, CharSequence.class));
                compiler.invoke(182, StringJoiner.class, "toString", String.class, new Class[0]);
            }
        } else {
            compiler.ldc(this.getValue());
        }
    }

    public boolean isTemplateString() {
        return this.expressionList != null;
    }

    private String transferString(String text) {
        StringBuilder builder = new StringBuilder();
        CharacterStream stream = new CharacterStream(text);
        while (stream.hasMore()) {
            if (stream.match("\\\\", true)) {
                builder.append('\\');
                continue;
            }
            if (stream.match("\\n", true)) {
                builder.append('\n');
                continue;
            }
            if (stream.match("\\r", true)) {
                builder.append('\r');
                continue;
            }
            if (stream.match("\\t", true)) {
                builder.append('\t');
                continue;
            }
            if (stream.match("\\\"", true)) {
                builder.append('\"');
                continue;
            }
            if (stream.match("\\'", true)) {
                builder.append("'");
                continue;
            }
            builder.append(stream.consume());
        }
        return builder.toString();
    }

    public String getValue() {
        if (this.token.getTokenStream() != null) {
            MagicScriptError.error("\u6b64\u5904\u4e0d\u652f\u6301\u6a21\u677f\u5b57\u7b26\u4e32", this.getSpan());
        }
        return this.transferString(this.getSpan().getText());
    }
}

