/*
 * Decompiled with CFR 0.152.
 */
package org.tio.common.starter;

import java.io.IOException;
import java.net.URL;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.FstCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.tio.common.starter.configuration.TioRedisClusterProperties;

public final class RedisInitializer {
    private static final Logger logger = LoggerFactory.getLogger(RedisInitializer.class);
    private RedissonClient redissonClient;
    private ApplicationContext applicationContext;
    private TioRedisClusterProperties redisConfig;

    public RedisInitializer(TioRedisClusterProperties redisConfig, ApplicationContext applicationContext) {
        this.redisConfig = redisConfig;
        this.applicationContext = applicationContext;
        this.initRedis();
    }

    public RedissonClient getRedissonClient() {
        return this.redissonClient;
    }

    public void shutdown() {
        if (this.redisConfig.useInjectRedissonClient() && !this.redissonClient.isShutdown()) {
            this.redissonClient.shutdown();
        }
    }

    private URL getFileUri(String fileName) {
        return this.applicationContext.getClassLoader().getResource(fileName);
    }

    private void initRedis() {
        Config config;
        if (this.redisConfig.useInjectRedissonClient()) {
            logger.info("Get the RedissonClient through injection, Bean name is \"{}\"", (Object)this.redisConfig.getClientBeanName());
            try {
                this.redissonClient = (RedissonClient)this.applicationContext.getBean(this.redisConfig.getClientBeanName(), RedissonClient.class);
                return;
            }
            catch (BeansException e) {
                logger.warn("RedissonClient is not found, Recreate RedissonClient on configuration information.");
            }
        }
        if ((config = this.getConfigByFile()) == null) {
            config = this.redisConfig.useConfigParameter() ? this.redisConfig.getClusterOrSentinelConfig() : this.getSingleServerConfig();
        }
        this.redissonClient = Redisson.create((Config)config);
    }

    private Config getConfigByFile() {
        try {
            if (this.redisConfig.isJSONConfig()) {
                return Config.fromJSON((URL)this.getFileUri(this.redisConfig.getConfigPath()));
            }
            if (this.redisConfig.isYAMLConfig()) {
                return Config.fromYAML((URL)this.getFileUri(this.redisConfig.getConfigPath()));
            }
        }
        catch (IOException e) {
            logger.error("init with file config error", (Throwable)e);
        }
        return null;
    }

    private Config getSingleServerConfig() {
        Config config = new Config();
        String address = this.redisConfig.toString();
        SingleServerConfig singleServerConfig = config.useSingleServer().setAddress(address).setConnectionPoolSize(this.redisConfig.getPoolSize().intValue()).setConnectionMinimumIdleSize(this.redisConfig.getMinimumIdleSize().intValue());
        if (this.redisConfig.hasPassword()) {
            singleServerConfig.setPassword(this.redisConfig.getPassword());
        }
        config.setCodec((Codec)new FstCodec());
        config.setLockWatchdogTimeout(30000L);
        return config;
    }
}

